--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;

function ShowHelp:updateTick(dt)
end;

function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.72, 0.20, 0.02, "Wcisnij Numpad 0: Info");
	else
		renderText(0.72, 0.86, 0.022, "-> -U-R-S-U-S- 1014 by LECHU & SPINAH ");			
		renderText(0.72, 0.81, 0.02, "Wcisnij Numpad 7: Prawe drzwi");
		renderText(0.72, 0.79, 0.02, "Wcisnij Numpad 9: Lewe drzwi");			
		renderText(0.72, 0.75, 0.02, "Wcisnij R-T: Dach");
		renderText(0.72, 0.77, 0.02, "Wcisnij K-L: Tylna szyba");
		renderText(0.72, 0.73, 0.02, "Wcisnij Numpad 5: Zaczep gora-dol");
		renderText(0.72, 0.71, 0.02, "Wcisnij Numpad 6: Zaczep gora-dol");
		renderText(0.72, 0.69, 0.02, "Wcisnij F: Swiatla");
		renderText(0.72, 0.67, 0.02, "Wcisnij N: Halogeny przod");
		renderText(0.72, 0.65, 0.02, "Wcisnij M: Halogeny tyl");
		renderText(0.72, 0.63, 0.02, "Wcisnij Numpad 1: Lewy kierunkowsakz");
		renderText(0.72, 0.61, 0.02, "Wcisnij Numpad 2: Swiatla awaryjne");
		renderText(0.72, 0.59, 0.02, "Wcisnij Numpad 3: Prawy kierunkowskaz");
		renderText(0.72, 0.57, 0.02, "Wcisnij 2x Num ENTER: Odpalanie silnika");
		renderText(0.72, 0.55, 0.02, "Wcisnij 5-6: Przygazowka");
	    renderText(0.72, 0.53, 0.02, "Wcisnij Spacja: Hamulec reczny");
	    renderText(0.72, 0.51, 0.02, "Wcisnij U: Sciagnij blotniki");
	
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;