
-- URSUS1204
-- by Lipa
-- www.landwirtschafts-simulator.pl

URSUS1204 = {};

function URSUS1204.prerequisitesPresent(specializations)
    return true;
end;

function URSUS1204:load(xmlFile)
 	
    local rotationPartNodeTylnaszyba = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tylnaszyba#index"));
    if rotationPartNodeTylnaszyba ~= nil then
        self.rotationPartTylnaszyba = {};
        self.rotationPartTylnaszyba.node = rotationPartNodeTylnaszyba;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tylnaszyba#minRot"));
        self.rotationPartTylnaszyba.minRot = {};
        self.rotationPartTylnaszyba.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTylnaszyba.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTylnaszyba.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tylnaszyba#maxRot"));
        self.rotationPartTylnaszyba.maxRot = {};
        self.rotationPartTylnaszyba.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTylnaszyba.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTylnaszyba.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTylnaszyba.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylnaszyba#rotTime"), 2)*1000;
        self.rotationPartTylnaszyba.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylnaszyba#touchRotLimit"), 10));
    end;
    local rotationPartNodePrawedrzwi = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.prawedrzwi#index"));
    if rotationPartNodePrawedrzwi ~= nil then
        self.rotationPartPrawedrzwi = {};
        self.rotationPartPrawedrzwi.node = rotationPartNodePrawedrzwi;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.prawedrzwi#minRot"));
        self.rotationPartPrawedrzwi.minRot = {};
        self.rotationPartPrawedrzwi.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawedrzwi.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawedrzwi.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.prawedrzwi#maxRot"));
        self.rotationPartPrawedrzwi.maxRot = {};
        self.rotationPartPrawedrzwi.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartPrawedrzwi.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartPrawedrzwi.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartPrawedrzwi.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.prawedrzwi#rotTime"), 2)*1000;
        self.rotationPartPrawedrzwi.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.prawedrzwi#touchRotLimit"), 10));
    end;
    local rotationPartNodeLewedrzwi = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lewedrzwi#index"));
    if rotationPartNodeLewedrzwi ~= nil then
        self.rotationPartLewedrzwi = {};
        self.rotationPartLewedrzwi.node = rotationPartNodeLewedrzwi;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lewedrzwi#minRot"));
        self.rotationPartLewedrzwi.minRot = {};
        self.rotationPartLewedrzwi.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewedrzwi.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewedrzwi.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.lewedrzwi#maxRot"));
        self.rotationPartLewedrzwi.maxRot = {};
        self.rotationPartLewedrzwi.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLewedrzwi.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLewedrzwi.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLewedrzwi.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.lewedrzwi#rotTime"), 2)*1000;
        self.rotationPartLewedrzwi.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.lewedrzwi#touchRotLimit"), 10));
    end;

end;

function URSUS1204:readStream(streamId, connection)
end;

function URSUS1204:writeStream(streamId, connection)
end;

function URSUS1204:update(dt)
	if self:getIsActiveForInput() then
	    if InputBinding.hasEvent(InputBinding.URSUS1204_TYLNASZYBA) then 
			self.rotationMaxTylnaszyba = not self.rotationMaxTylnaszyba;
		end;
	    if InputBinding.hasEvent(InputBinding.URSUS1204_PRAWEDRZWI) then 
			self.rotationMaxPrawedrzwi = not self.rotationMaxPrawedrzwi;
		end;
	    if InputBinding.hasEvent(InputBinding.URSUS1204_LEWEDRZWI) then 
			self.rotationMaxLewedrzwi = not self.rotationMaxLewedrzwi;
		end;
	end;
end;

function URSUS1204:updateTick(dt)
    if self.rotationPartTylnaszyba ~= nil then
        local x, y, z = getRotation(self.rotationPartTylnaszyba.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartTylnaszyba.maxRot, self.rotationPartTylnaszyba.minRot, 3, self.rotationPartTylnaszyba.rotTime, dt, not self.rotationMaxTylnaszyba);
        setRotation(self.rotationPartTylnaszyba.node, unpack(newRot));
    end;
    if self.rotationPartPrawedrzwi ~= nil then
        local x, y, z = getRotation(self.rotationPartPrawedrzwi.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartPrawedrzwi.maxRot, self.rotationPartPrawedrzwi.minRot, 3, self.rotationPartPrawedrzwi.rotTime, dt, not self.rotationMaxPrawedrzwi);
        setRotation(self.rotationPartPrawedrzwi.node, unpack(newRot));
    end;
    if self.rotationPartLewedrzwi ~= nil then
        local x, y, z = getRotation(self.rotationPartLewedrzwi.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLewedrzwi.maxRot, self.rotationPartLewedrzwi.minRot, 3, self.rotationPartLewedrzwi.rotTime, dt, not self.rotationMaxLewedrzwi);
        setRotation(self.rotationPartLewedrzwi.node, unpack(newRot));
    end;
end;

function URSUS1204:delete()
end;

function URSUS1204:mouseEvent(posX, posY, isDown, isUp, button)
end;

function URSUS1204:keyEvent(unicode, sym, modifier, isDown)
end;		

function URSUS1204:draw()
end;


