--
-- Specialization for Kierownica
-- 
-- version 1 and 2 by Henly20 (Ls_uk Modteam)
-- @author:		Xentro (www.ls-uk.info)
-- @version:	v3.0
-- @date:		2012-03-18
--
--
Kierownica = {};

function Kierownica.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Kierownica:load(xmlFile)
	self.setKierownica = SpecializationUtil.callSpecializationsFunction("setKierownica");
	
	self.oldAutoRotateBackSpeed = self.autoRotateBackSpeed;
	self.oldMaxRotatedTimeSpeed = self.maxRotatedTimeSpeed;
	self.haveKierownica = true;
	
	self.steer = {};
	self.steer.invertAxis = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.Kierownica#invertAxis"), false);
	self.steer.speed = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.Kierownica#steeringSpeed"), 1000);
	
	local input = getXMLString(xmlFile,"vehicle.Kierownica#inputBinding");
	if InputBinding[input] ~= nil then self.steer.input = input; end;
	
	local activated = Utils.getNoNil(getXMLBool(xmlFile,"vehicle.Kierownica#activated"), false);
	if activated then
		self.steeringLocked = false;
	else
		self.steeringLocked = true;
	end;
	if self.steeringLocked then
		self.autoRotateBackSpeed = 0;
		self.maxRotatedTimeSpeed = 0;
	end;
	
	local KierownicaImage = getXMLString(xmlFile,"vehicle.KierownicaHud#released");
	local KierownicaLockImage = getXMLString(xmlFile,"vehicle.KierownicaHud#locked");
	if KierownicaImage ~= nil and KierownicaLockImage ~= nil then
		self.KierownicaHudX = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.KierownicaHud#posX"), 0.93);
		self.KierownicaHudY = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.KierownicaHud#posY"), 0.8);
		self.KierownicaHudWidth = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.KierownicaHud#width"), 0.065);
		self.KierownicaHudHeight = Utils.getNoNil(getXMLFloat(xmlFile,"vehicle.KierownicaHud#height"), 0.095);
		self.KierownicaReleasedOverlay = Overlay:new("KierownicaImageOverlay", Utils.getFilename(KierownicaImage, self.baseDirectory), self.KierownicaHudX, self.KierownicaHudY, self.KierownicaHudWidth, self.KierownicaHudHeight);
		self.KierownicaLockOverlay = Overlay:new("KierownicaLockImageOverlay", Utils.getFilename(KierownicaLockImage, self.baseDirectory), self.KierownicaHudX, self.KierownicaHudY, self.KierownicaHudWidth, self.KierownicaHudHeight);
		self.showKierownicaHud = true;
	end;
end;

function Kierownica:delete()
	if self.KierownicaReleasedOverlay ~= nil and self.KierownicaLockOverlay ~= nil then
		self.KierownicaReleasedOverlay:delete();
		self.KierownicaLockOverlay:delete();
	end;
end;

function Kierownica:readStream(streamId, connection)
    self:setKierownica(streamReadBool(streamId), true);
end;

function Kierownica:writeStream(streamId, connection)
    streamWriteBool(streamId, self.steeringLocked);
end;

function Kierownica:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kierownica:keyEvent(unicode, sym, modifier, isDown)
end;

function Kierownica:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local steeringLocked = Utils.getNoNil(getXMLBool(xmlFile, key.."#steeringLocked"), true);
		self:setKierownica(steeringLocked);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Kierownica:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'steeringLocked="'..tostring(self.steeringLocked)..'"';
	return attributes, nil;
end;

function Kierownica:update(dt)
	if self:getIsActive() then
		if self.steer.input ~= nil then
			if self:getIsActiveForInput() and self.isClient then
				if InputBinding.hasEvent(InputBinding[self.steer.input]) then
					self:setKierownica(not self.steeringLocked);
				end;
			end;
		end;
	end;
end;

function Kierownica:updateTick(dt)
end;

function Kierownica:draw()
	if self.isClient then
		if self.KierownicaReleasedOverlay ~= nil and self.KierownicaLockOverlay ~= nil then
			if self.showKierownicaHud then
				if not self.steeringLocked then
					self.KierownicaLockOverlay:render();
				else
					self.KierownicaReleasedOverlay:render();
				end;
			end;
		end;  
	end;  
end;

function Kierownica:setKierownica(lockedsteer, noEventSend)
	if lockedsteer ~= nil then
		SetKierownicaEvent.sendEvent(self, lockedsteer, noEventSend)
		self.steeringLocked = lockedsteer;
		
		if not lockedsteer then
			self.autoRotateBackSpeed = 0;
			self.maxRotatedTimeSpeed = 0;
		else
			self.autoRotateBackSpeed = self.oldAutoRotateBackSpeed;
			self.maxRotatedTimeSpeed = self.oldMaxRotatedTimeSpeed;
		end;
	end;
end;

-- Event --
SetKierownicaEvent = {};
SetKierownicaEvent_mt = Class(SetKierownicaEvent, Event);
  
InitEventClass(SetKierownicaEvent, "SetKierownicaEvent");
  
function SetKierownicaEvent:emptyNew()
	local self = Event:new(SetKierownicaEvent_mt);
	self.className="SetKierownicaEvent";
	return self;
end;
  
function SetKierownicaEvent:new(object, lockedsteer)
	local self = SetKierownicaEvent:emptyNew()
	self.object = object;
	self.lockedsteer = lockedsteer;
	return self;
end;
  
function SetKierownicaEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.lockedsteer = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;
  
function SetKierownicaEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.lockedsteer);
end;
  
function SetKierownicaEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	self.object:setKierownica(self.lockedsteer, true);
end;
  
function SetKierownicaEvent.sendEvent(vehicle, lockedsteer, noEventSend)
	if lockedsteer ~= vehicle.steeringLocked then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetKierownicaEvent:new(vehicle, lockedsteer), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetKierownicaEvent:new(vehicle, lockedsteer));
			end;
		end;
	end;
end;