--
-- ExtraLightSources
-- Specialization for ExtraLightSources
--
-- @author:  	Manuel Leithner
-- @date:		20/10/10
-- @version:	v1.0
-- @history:	v1.0 - initial implementation
--

ExtraLightSources = {};

function ExtraLightSources.prerequisitesPresent(specializations)
    return true
end;

function ExtraLightSources:load(xmlFile)

	self.setLightState = SpecializationUtil.callSpecializationsFunction("setLightState");

	local numLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.lightSources#count"), 0);
    self.lightsSource = {};
    for i=1, numLights do
        local lightnamei = string.format("vehicle.lightSources.source%d", i);
		self.lightsSource[i] = {};
        self.lightsSource[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#index"));
		self.lightsSource[i].backPartLights = nil;
		if hasXMLProperty(xmlFile, lightnamei .. "#backPartLights") then
			self.lightsSource[i].backPartLights = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#backPartLights"));
		end;
		self.lightsSource[i].lights = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#lights"));
		self.lightsSource[i].lights2 = Utils.indexToObject(self.components, getXMLString(xmlFile, lightnamei .. "#lights2"));
		setVisibility(self.lightsSource[i].lights, false);
		setVisibility(self.lightsSource[i].lights2, false);
		setVisibility(self.lightsSource[i].backPartLights, false);
        setVisibility(self.lightsSource[i].node, false);
    end;

	self.currentLight = 0;	
end;

function ExtraLightSources:delete()
end;

function ExtraLightSources:readStream(streamId, connection)
	self:setLightState(streamReadInt8(streamId), true);
end;

function ExtraLightSources:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentLight);
end;

function ExtraLightSources:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ExtraLightSources:keyEvent(unicode, sym, modifier, isDown)
end;

function ExtraLightSources:update(dt)
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			-- Modulo division to get a controlled switch between each lights
			if InputBinding.hasEvent(InputBinding.TOGGLE_LIGHTS) then
				self:setLightState((self.currentLight + 1) % (table.getn(self.lightsSource) + 1));
			end;
		end;
	end;
end;

function ExtraLightSources:updateTick(dt)
end;

function ExtraLightSources:draw()
end;

function ExtraLightSources:setLightsVisibility(isActive)
    if not self.isControlled then
        if g_currentMission.environment.isSunOn then
            self:setLightState(0);
        else
            self:setLightState(1);
        end;
    end;
end;

-- state 0: disabled
-- state 1: normal light
-- state 2: working light
function ExtraLightSources:setLightState(state, noEventSend)
	LightStateEvent.sendEvent(self, state, noEventSend);
	
	if self.currentLight == state  then
		state = 0;
	end;
	if state >= 0 and state <= table.getn(self.lightsSource) then
		self:setLightsVisibility(state > 0, true);		
		if self.currentLight > 0 then
			setVisibility(self.lightsSource[self.currentLight].node, false);
			setVisibility(self.lightsSource[self.currentLight].lights, false);
			setVisibility(self.lightsSource[self.currentLight].lights2, false);
			if self.lightsSource[self.currentLight].backPartLights ~= nil then
				setVisibility(self.lightsSource[self.currentLight].backPartLights, false);
			end;
		end;
		if state > 0 then
			setVisibility(self.lightsSource[state].node, true);
			if self:getIsActiveForSound() then
				setVisibility(self.lightsSource[state].lights, true);
				setVisibility(self.lightsSource[state].lights2, true);
			end;
			if self.lightsSource[state].backPartLights ~= nil then
				setVisibility(self.lightsSource[state].backPartLights, true);
			end;
		end;
		self.currentLight = state;		
	else
		print("Error: given light state not available");
	end;
end;

function ExtraLightSources:onLeave()
    self.deactivateLightsOnLeave = false;
end;