--
-- MMRearCam
--
-- Rckfahr-Kamera
--
-- by MMAgrarservice
--
-- @complement by Amarlich (16.01.2013)
--

MMRearCam = {};

function MMRearCam.prerequisitesPresent(specializations)
    return true;
end;

function MMRearCam:load()
	self.MMRearCamPosX = 0.45;
	self.MMRearCamWidth = 0.30;
	self.MMRearCamPosY = 0.79;
	self.MMRearCamHeight = 0.20;
        self.MMRearCamFrame = Utils.getFilename("textures/MMRearCamFrame.dds", self.baseDirectory);
	self.MMRearCamFrameOverlay = Overlay:new("MMRearCamFrameOverlay", self.MMRearCamFrame, self.MMRearCamPosX, self.MMRearCamPosY, self.MMRearCamWidth, self.MMRearCamHeight);
	self.showMMRearCam = 0;
end;

function MMRearCam:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MMRearCam:keyEvent(unicode, sym, modifier, isDown)
end;

function MMRearCam:update()
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.MMRearCam) and self.isEntered then
			self.showMMRearCam = self.showMMRearCam+1;
			if self.showMMRearCam == 2 then
				self.showMMRearCam = 0;
			end;
		end;
	end;
end;
	
function MMRearCam:draw()
	if self.showMMRearCam == 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("MMRearCamOFF"), InputBinding.MMRearCam);
		self.MMRearCam = 0;
		link(self.rootNode, self.MMRearCam);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.46, 0.03, 0.28, 0.15);
		setCamera(self.MMRearCam,1);
	elseif self.showMMRearCam == 1 then
		g_currentMission:addHelpButtonText(g_i18n:getText("MMRearCamON"), InputBinding.MMRearCam);
		self.MMRearCam = createCamera("MMRearCam", 85, 0.1, 100);
		link(self.rootNode, self.MMRearCam);
		translate (self.MMRearCam,0,4,-3);
		rotate(self.MMRearCam,-0.65,0,0);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.46, 0.03, 0.28, 0.15);
		setCamera(self.MMRearCam,1);
		self.MMRearCamFrameOverlay:render();
	end;
end;

function MMRearCam:delete()
end;

function MMRearCam:onLeave()
		self.MMRearCam = 0;
		link(self.rootNode, self.MMRearCam);
		node = getRootNode(0);
		setRootNode(node, 1);
		setViewport(1, 0.46, 0.03, 0.28, 0.15);
		setCamera(self.MMRearCam,1);
end;
