--[[#############################################
@author 		FIAT80-90DT
@version		0.1.0 - 17.09.2013 - initial Version
				0.2.0 - 19.09.2013 - encapsulate from ramp.lua
				0.3.0 - 28.09.2013 - rotLimits added
#############################################]]--


CultivatorShares = {};

function CultivatorShares.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cultivator, specializations);
end;

function CultivatorShares:load(xmlFile)
	self.stoneCrash = SpecializationUtil.callSpecializationsFunction("stoneCrash");

	self.crashFactor = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cultivatorShares#crashFactor"), 1)*10;
	self.lastFigure = 0;
	
	self.shares = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.cultivatorShares.share(%d)", i);
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#node"));
		
		if node == nil then
			break;
		end;
		
		local animCharSet = getAnimCharacterSet(node);
		if animCharSet ~= 0 then
			local clipName = getXMLString(xmlFile, key .. "#clipName");
			local clip = getAnimClipIndex(animCharSet, clipName);
			if clip >= 0 then
                local entry = {};				
				entry.animCharSet = animCharSet;
                assignAnimTrackClip(entry.animCharSet, 0, clip);
                setAnimTrackLoopState(entry.animCharSet, 0, false);
				entry.animDuration = getAnimClipDuration(entry.animCharSet, clip);
				entry.clipIndex = clip;
				table.insert(self.shares, entry);
			end
		end;
		i = i+1;
	end;
end;

function CultivatorShares:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
end;

function CultivatorShares:getSaveAttributesAndNodes(nodeIdent)
end;

function CultivatorShares:delete()
end;

function CultivatorShares:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CultivatorShares:keyEvent(unicode, sym, modifier, isDown)
end;

function CultivatorShares:update(dt)
	if self:getIsActive(false) then
		if self.cultivatorHasGroundContact and self.movingDirection > 0 then
			local crash = math.random(-1 * self.crashFactor, self.crashFactor);
			if crash == self.shares.lastFigure then
				local idx = math.random(1, table.getn(self.shares));
				if self.shares[idx] ~= nil then
					self:stoneCrash(idx);
				end;
			end;	
			self.shares.lastFigure = crash;
		end;
	end;
end;

function CultivatorShares:stoneCrash(shareIndex, noEventSend)
	local share = self.shares[shareIndex];
	if share ~= nil then
		disableAnimTrack(share.animCharSet, 0);
		setAnimTrackTime(share.animCharSet,0,0);
		setAnimTrackSpeedScale(share.animCharSet, 0, math.max(self.lastSpeed*1300, 1));
		enableAnimTrack(share.animCharSet, 0);
	end;
	StoneCrashEvent.sendEvent(self, shareIndex, noEventSend);
end;

function CultivatorShares:draw()
end;

function CultivatorShares:readStream(streamId, connection)   
end;

function CultivatorShares:writeStream(streamId, connection) 
end;

StoneCrashEvent = {};
StoneCrashEvent_mt = Class(StoneCrashEvent, Event);

InitEventClass(StoneCrashEvent, "StoneCrashEvent");

function StoneCrashEvent:emptyNew()
    local self = Event:new(StoneCrashEvent_mt);
    return self;
end;

function StoneCrashEvent:new(vehicle, shareIndex)
    local self = StoneCrashEvent:emptyNew()
    self.vehicle = vehicle;
	self.shareIndex = shareIndex;
    return self;
end;

function StoneCrashEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.shareIndex = streamReadInt8(streamId);

	self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function StoneCrashEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteInt8(streamId, self.shareIndex);
end;

function StoneCrashEvent:run(connection)
	self.vehicle:stoneCrash(self.shareIndex, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(StoneCrashEvent:new(self.vehicle, self.shareIndex), nil, nil, self.vehicle);
	end;
end;

function StoneCrashEvent.sendEvent(vehicle, shareIndex, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(StoneCrashEvent:new(vehicle, shareIndex), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(StoneCrashEvent:new(dynamicHandTool, shareIndex));
		end;
	end;
end;






