--
-- Ursus C360 Kabina
--
-- M@D Author:  Fumski
-- M@D date: 05.06.2012
--
-- > Copyright (C) Fumski - Www.LS-Modteam.pl < --
--

UrsusC360K = {};

function UrsusC360K.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function UrsusC360K:load(xmlFile)

	self.setHydraulicTime = 30;

    self.helpPanelWidth = 0.28;
  	self.helpPanelHeight = 0.38;
	self.helpPanelPoxX = -0.00;
   	self.helpPanelPoxY = 1-0.65;
    self.helpPanelOverlay = Overlay:new("helpPanel", Utils.getFilename("tex/Info.png", self.baseDirectory), self.helpPanelPoxX, self.helpPanelPoxY, self.helpPanelWidth, self.helpPanelHeight);
	self.helpPanelActive = false;

    local Drzwi3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Drzwi3#index"));
	if Drzwi3 ~= nil then
	    self.Drzwi3 = Drzwi3;
	end;
    local Drzwi4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Drzwi4#index"));
	if Drzwi4 ~= nil then
	    self.Drzwi4 = Drzwi4;
	end;
    local Maska1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Maska1#index"));
	if Maska1 ~= nil then
	    self.Maska1 = Maska1;
	end;
    local Pompka1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pompka1#index"));
	if Pompka1 ~= nil then
	    self.Pompka1 = Pompka1;
	end;

	self.setHydraulicDirection = SpecializationUtil.callSpecializationsFunction("setHydraulicDirection");
	self.Belka = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Belka#index"));
	self.Sruba = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Sruba#index"));
 	setVisibility((self.Belka), true);
 	setVisibility((self.Sruba), false);
	self.rotationMax3Active = false;
	self.rotationMax2Active = false;
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.hydraulics = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);		
		self.hydraulics[i] = {};		
		self.hydraulics[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics[i].fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));	
		local xUp, yUp, zUp = Utils.getVectorFromString(Utils.getNoNil(getXMLString(xmlFile, hydraulicName .. "#upVectors"),"0 1 0"));
		self.hydraulics[i].upVectors = {xUp, yUp, zUp};
		
		local ax, ay, az;		
		if self.hydraulics[i].punch ~= nil then
			ax, ay, az = getWorldTranslation(self.hydraulics[i].punch);
		else
			ax, ay, az = getWorldTranslation(self.hydraulics[i].node);
		end;
		if self.hydraulics[i].translationPunch ~= nil then
			local bx, by, bz = getWorldTranslation(self.hydraulics[i].translationPunch);		
			self.hydraulics[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;
	end;

    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;

	self.isWiperActive = false;
	self.finishWiper = true;

	local rotationPartNodeLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

	local rotationRpmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationRpm#index"));
		if rotationRpmNode ~= nil then
        self.rotationRpm = {};
        self.rotationRpm.node = rotationRpmNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#minRot"));
        self.rotationRpm.minRot = {};
        self.rotationRpm.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationRpm#maxRot"));
        self.rotationRpm.maxRot = {};
        self.rotationRpm.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationRpm.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationRpm.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationRpm.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#rotTime"), 2)*1000;
        self.rotationRpm.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationRpm#touchRotLimit"), 10));
    end;
	
	local rotationPartNode5 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
    if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
    end;

	local rotationPartNode4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
    if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
    end;

	local rotationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
		if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
    end;

	local rotationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
    if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
    end;

	local rotationPartNode1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPart1#index"));
    if rotationPartNode1 ~= nil then
        self.rotationPart1 = {};
        self.rotationPart1.node = rotationPartNode1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#minRot"));
        self.rotationPart1.minRot = {};
        self.rotationPart1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart1#maxRot"));
        self.rotationPart1.maxRot = {};
        self.rotationPart1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#rotTime"), 2)*1000;
        self.rotationPart1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart1#touchRotLimit"), 10));
    end;

	local rotationLifter = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Lifter#index"));
	self.Lifter = {};
	self.Lifter.node = rotationLifter;

	local rotationLifterArm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterArm#index"));
	self.LifterArm = {};
	self.LifterArm.node = rotationLifterArm;

	local rotationLifterBottom = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.LifterBottom#index"));
	self.bottomArm2 = {};
	self.bottomArm2.node = rotationLifterBottom;

	local BottomArmNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.attacherJoints.attacherJoint.bottomArm#rotationNode"));
	self.bottomArm = {};
	self.bottomArm.node = BottomArmNode;

	self.backAttacherJoint = {};
	self.backAttacherJoint.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#node"));
	self.backAttacherJoint.lowRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#lowRot"));
	self.backAttacherJoint.upRot = Utils.degToRad(getXMLFloat(xmlFile, "vehicle.trailerAttacherJoints#upRot"));

end;

function UrsusC360K:delete()
end;

function UrsusC360K:mouseEvent(posX, posY, isDown, isUp, button)
end;

function UrsusC360K:keyEvent(unicode, sym, modifier, isDown)
end;

function UrsusC360K:update(dt)
	if self:getIsActiveForInput() and self.isEntered then   
        if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			self.rotationMax4Active = not self.rotationMax4Active;
        end;
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self.rotationMax5Active = not self.rotationMax5Active;
        end;
	end;

	if InputBinding.hasEvent(InputBinding.C360) then
		self.helpPanelActive = not self.helpPanelActive;
	end;

	if self.setHydraulicTime > 0 then
		for k,v in pairs(self.hydraulics) do 
			self:setHydraulicDirection(k);
		end;
		self.setHydraulicTime = self.setHydraulicTime - 1;
	end;
	
	if self:getIsActive() then
	self.setHydraulicTime = 30;	
	inputAxisY = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);

	if InputBinding.isAxisZero(inputAxisY) then
        inputAxisY = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
    end;
		if self.isEntered ~= nil then
			if (self.movingDirection*self.lastSpeed*(-inputAxisY)) < -0.001 then		
				self.rotationMax3Active = true;
				self.rotationMax2Active = true;
			else
				self.rotationMax3Active = false;
				self.rotationMax2Active = false;
			end;
		end;
		local maxrpmneedle = 2500;
		if self.rotationRpm ~= nil and self.isMotorStarted == true then
		local x, y, z = getRotation(self.rotationRpm.node);
		local range = math.deg(self.rotationRpm.maxRot[2]) - math.deg(self.rotationRpm.minRot[2])
		local crpm = self.motor.lastMotorRpm*3
		local p = (crpm/maxrpmneedle) 
			y = self.rotationRpm.minRot[2] + math.rad((range*p)+(math.random(0,20)-10))
			setRotation(self.rotationRpm.node, x, y ,z);
		elseif self.rotationRpm ~= nil and self.isMotorStarted == false then
			setRotation(self.rotationRpm.node, 0, 0 ,0);
		end;
		if self.rotationPart5 ~= nil then
			local x, y, z = getRotation(self.rotationPart5.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax5Active);
			setRotation(self.rotationPart5.node, unpack(newRot));
		end;
		if self.rotationPart4 ~= nil then
			local x, y, z = getRotation(self.rotationPart4.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax4Active);
			setRotation(self.rotationPart4.node, unpack(newRot));
		end;
		if self.rotationPart3 ~= nil then
			local x, y, z = getRotation(self.rotationPart3.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax3Active);
			setRotation(self.rotationPart3.node, unpack(newRot));
		end;
		if self.rotationPart2 ~= nil then
			local x, y, z = getRotation(self.rotationPart2.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax2Active);
			setRotation(self.rotationPart2.node, unpack(newRot));
		end;	
		local maxhandthrottle = 2500;
		if self.rotationPart1 ~= nil and self.isMotorStarted == true then
			local x, y, z = getRotation(self.rotationPart1.node);
			z = ((self.rotationPart1.maxRot[3] - self.rotationPart1.minRot[3]) / maxhandthrottle) * (self.motor.lastMotorRpm*3) + self.rotationPart1.minRot[3];
			setRotation(self.rotationPart1.node, x, y ,z);
		elseif self.isMotorStarted == false then
			setRotation(self.rotationPart1.node, 0, 0 ,0);
		end;
		if self.Lifter.node ~= nil and self.bottomArm2.node ~= nil then
			rBBArmX, rBBArmY, rBBArmZ = getRotation(self.bottomArm2.node);
			setRotation(self.Lifter.node, rBBArmX*1.05, 0, 0);
		end;
		if self.LifterArm.node ~= nil and self.bottomArm2.node ~= nil then
			setRotation(self.LifterArm.node, 0.05-rBBArmX*1.1, 0, 0);
		end;
	end;
	if self.rotationPartLeft ~= nil then
		local x, y, z = getRotation(self.rotationPartLeft.node);
		x = (self.rotationPartLeft.maxRot[1] - self.rotationPartLeft.minRot[1]) * (self.rotatedTime/-1);
		setRotation(self.rotationPartLeft.node, x, y ,z);
	end;
    local nearestDistance = 2;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Drzwi3); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Drzwil = true;
	else
		self.Drzwil = false;
	end;
	if self.Drzwil or self.isEntered then
		if InputBinding.hasEvent(InputBinding.Drzwi3) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
	end;
	if self.Drzwil then
		if self.animationParts[3].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi3)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi3)));
		end;
	end
    local nearestDistance = 2;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Drzwi4); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Drzwip = true;
	else
		self.Drzwip = false;
	end;
	if self.Drzwip or self.isEntered then
		if InputBinding.hasEvent(InputBinding.Drzwi4) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;
	end;
	if self.Drzwip then
		if self.animationParts[4].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi4)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi4)));
		end;
	end
    local nearestDistance = 1.5;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Maska1); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Maskas = true;
	else
		self.Maskas = false;
	end;
	if self.Maskas then
		if InputBinding.hasEvent(InputBinding.Maska1) then
			if self.animationParts[6].clipEndTime then
				self:setAnimationTime(6, self.animationParts[6].offSet);
			elseif self.animationParts[6].clipStartTime then
				self:setAnimationTime(6, self.animationParts[6].animDuration);
			end;
		end;
	end;
	if self.Maskas then
		if self.animationParts[6].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Maska1)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Maska1)));
		end;
	end
    local nearestDistance = 1;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Pompka1); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Pompkas = true;
	else
		self.Pompkas = false;
	end;
	if self.Pompkas then
		if InputBinding.hasEvent(InputBinding.Pompka1) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].offSet);
			elseif self.animationParts[7].clipStartTime then
				self:setAnimationTime(7, self.animationParts[7].animDuration);
			end;
		end;
	end;
	if self.Pompkas then
		if self.animationParts[7].clipStartTime then
		    g_currentMission:addExtraPrintText(string.format("%s: Pompka paliwa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Pompka1)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Pompka paliwa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Pompka1)));
        end;
	end
	if self.isEntered then	
		if InputBinding.hasEvent(InputBinding.Dach) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Tylszyba) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Drzwi1) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Drzwi2) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Gabka) then
			if self.animationParts[5].clipEndTime then
				self:setAnimationTime(5, self.animationParts[5].offSet);
			elseif self.animationParts[5].clipStartTime then
				self:setAnimationTime(5, self.animationParts[5].animDuration);
			end;
		end;
	end;
end;

function UrsusC360K:updateTick(dt)
	if self:getIsActive() then
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm			
			local x, y, z = getRotation(self.attacherJoints[1].bottomArm.rotationNode);
			setRotation(self.backHydraulic.rootArm, x, y, z);	
		end;	
	end;
	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(11, 1);
		else
			self:setAnimationTime(11, 0);
		end;
		if self.isMotorStarted then
			self:setAnimationTime(12, 1);
		else
			self:setAnimationTime(12, 0);
		end;
	end;
end;

function UrsusC360K:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return true;
end;

function UrsusC360K:draw()
   	if self.helpPanelActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("C360Off"), InputBinding.C360);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("C360On"), InputBinding.C360);
	end;
	if self.helpPanelOverlay ~= nil then
		if self.helpPanelActive then
			self.helpPanelOverlay:render();
		end;
	end;
	if self.helpPanelActive then
		if self.animationParts[1].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.635, 0.018, "Klawisz Num 4: Dach");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.635, 0.018, "Dach zamkniety");
		end;
		if self.animationParts[2].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.615, 0.018, "Tylna szyba zamknieta");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.615, 0.018, "Klawisz NUM 8: Tylna szyba");
		end;
		if self.animationParts[3].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.595, 0.018, "Klawisz NUM 7: Drzwi lewe");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.595, 0.018, "Drzwi lewe zamkniete");
		end;
		if self.animationParts[4].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.575, 0.018, "Klawisz NUM 9: Drzwi prawe");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.575, 0.018, "Drzwi prawe zamkniete");
		end;
		if self.animationParts[5].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.555, 0.018, "Gabka ustawiona");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.555, 0.018, "Klawisz NUM 6: Gabka");
		end;
		if self.animationParts[6].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.535, 0.018, "Maska zamknieta");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.535, 0.018, "Maska otwarta");
		end;
	end;
end;

function UrsusC360K:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function UrsusC360K:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function UrsusC360K:attachImplement(implement)
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;
	
	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if jointIndex == 1 then
			setVisibility((self.Sruba), true);
			setVisibility((self.Belka), false);
		end;
	end;
	if jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility((self.Sruba), false);
			setVisibility((self.Belka), true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then	
			setVisibility((self.Sruba), false);
			setVisibility((self.Belka), true);
		end;
	end;
	self.updateJoint = true;
end;

function UrsusC360K:detachImplement(implementIndex)
	self.rotationMax4Active = false;
	self.rotationMax5Active = false;
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;
	
	if jointIndex == 1 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end;
	if jointIndex == 2 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end
	if jointIndex == 3 then
		setVisibility((self.Sruba), false);
		setVisibility((self.Belka), true);
	end;
end;

function UrsusC360K:setHydraulicDirection(index)
	local hydraulic = self.hydraulics[index];

	if hydraulic.fixPoint ~= nil then
		local ax, ay, az = getWorldTranslation(hydraulic.node);
		local bx, by, bz = getWorldTranslation(hydraulic.fixPoint);
		local x, y, z = worldDirectionToLocal(getParent(hydraulic.node), bx-ax, by-ay, bz-az);
		local xUp, yUp, zUp = unpack(hydraulic.upVectors);
		setDirection(hydraulic.node, x, y, z, xUp, yUp, zUp);
		if hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(hydraulic.punch, 0, 0, distance-hydraulic.punchDistance);
		end;
	end;
end;
