--
-- //// C360 //// 
--   By Fumski
--

C360 = {};

function C360.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function C360:validateAttacherJoint(implement, jointDesc, dt)
return true;
end;

function C360:load(xmlFile)

    local Drzwi3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Drzwi3#index"));
	if Drzwi3 ~= nil then
	    self.Drzwi3 = Drzwi3;
	end;
    local Drzwi4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Drzwi4#index"));
	if Drzwi4 ~= nil then
	    self.Drzwi4 = Drzwi4;
	end;
    local Maska1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Maska1#index"));
	if Maska1 ~= nil then
	    self.Maska1 = Maska1;
	end;
    local Pompka1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Pompka1#index"));
	if Pompka1 ~= nil then
	    self.Pompka1 = Pompka1;
	end;

    self.helpPanelWidth = 0.28;
  	self.helpPanelHeight = 0.33;
	self.helpPanelPoxX = -0.00;
   	self.helpPanelPoxY = 1-0.50;
    self.helpPanelOverlay = Overlay:new("helpPanel", Utils.getFilename("tex/Info.png", self.baseDirectory), self.helpPanelPoxX, self.helpPanelPoxY, self.helpPanelWidth, self.helpPanelHeight);
	self.helpPanelActive = false;

	-- Defines attributes of backHydraulic
	self.backHydraulic = {};
	self.backHydraulic.rootArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#rootArm"));
	self.backHydraulic.bottomArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backHydraulic#bottomArm"));

	self.fenders = {};
	self.fenders.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index"));
	self.fenders.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fenders#index2"));
	
    local wiperAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiper#rootNode"));
    self.wiperAnimCharSet = 0;
    if wiperAnimRootNode ~= nil and wiperAnimRootNode ~= 0 then
        self.wiperAnimCharSet = getAnimCharacterSet(wiperAnimRootNode);
        if self.wiperAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperAnimCharSet, getXMLString(xmlFile, "vehicle.wiper#clip"));
            assignAnimTrackClip(self.wiperAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperAnimCharSet, 0, true);
            local wiperAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiper#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperAnimCharSet, 0, wiperAnimSpeedScale);
            self.wiperAnimDuration = getAnimClipDuration(self.wiperAnimCharSet, clip);
        end;
    end;

	self.isWiperActive = false;
	self.finishWiper = true;

end;

function C360:delete()
end;

function C360:mouseEvent(posX, posY, isDown, isUp, button)
end;

function C360:keyEvent(unicode, sym, modifier, isDown)
end;

function C360:update(dt)

    local nearestDistance = 1.5;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Drzwi3); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Drzwil = true;
	else
		self.Drzwil = false;
	end;
	if self.Drzwil or self.isEntered then
	if InputBinding.hasEvent(InputBinding.Drzwi3) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
	end;
	if self.Drzwil then
	if self.animationParts[3].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi3)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi3)));
		end;
	end

    local nearestDistance = 1.5;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Drzwi4); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Drzwip = true;
	else
		self.Drzwip = false;
	end;
	if self.Drzwip or self.isEntered then
	if InputBinding.hasEvent(InputBinding.Drzwi4) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;
	end;
	if self.Drzwip then
	if self.animationParts[4].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi4)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Drzwi", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Drzwi4)));
		end;
	end

    local nearestDistance = 1;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Maska1); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Maskas = true;
	else
		self.Maskas = false;
	end;
	if self.Maskas then
	if InputBinding.hasEvent(InputBinding.Maska1) then
			if self.animationParts[6].clipEndTime then
				self:setAnimationTime(6, self.animationParts[6].offSet);
			elseif self.animationParts[6].clipStartTime then
				self:setAnimationTime(6, self.animationParts[6].animDuration);
			end;
		end;
	end;
	if self.Maskas then
	if self.animationParts[6].clipStartTime then
			g_currentMission:addExtraPrintText(string.format("%s: Otworz Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Maska1)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Zamknij Maske", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Maska1)));
		end;
	end

    local nearestDistance = 1;
	local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
	local px, py, pz = getWorldTranslation(self.Pompka1); 
	local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
	if distance < nearestDistance then
		self.Pompkas = true;
	else
		self.Pompkas = false;
	end;
	if self.Pompkas then
	if InputBinding.hasEvent(InputBinding.Pompka1) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].offSet);
			elseif self.animationParts[7].clipStartTime then
				self:setAnimationTime(7, self.animationParts[7].animDuration);
			end;
		end;
	end;
	if self.Pompkas then
	if self.animationParts[7].clipStartTime then
		    g_currentMission:addExtraPrintText(string.format("%s: Pompka paliwa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Pompka1)));
		else
			g_currentMission:addExtraPrintText(string.format("%s: Pompka paliwa", InputBinding.getKeyNamesOfDigitalAction(InputBinding.Pompka1)));
        end;
	end

	if self.isEntered then	
	if InputBinding.hasEvent(InputBinding.Dach) then
		if self.animationParts[1].clipEndTime then
			self:setAnimationTime(1, self.animationParts[1].offSet);
		elseif self.animationParts[1].clipStartTime then
			self:setAnimationTime(1, self.animationParts[1].animDuration);
	    end;
	end;
	if InputBinding.hasEvent(InputBinding.Tylszyba) then
		if self.animationParts[2].clipEndTime then
			self:setAnimationTime(2, self.animationParts[2].offSet);
		elseif self.animationParts[2].clipStartTime then
			self:setAnimationTime(2, self.animationParts[2].animDuration);
	    end;
	end;
	if InputBinding.hasEvent(InputBinding.Drzwi1) then
		if self.animationParts[3].clipEndTime then
			self:setAnimationTime(3, self.animationParts[3].offSet);
		elseif self.animationParts[3].clipStartTime then
			self:setAnimationTime(3, self.animationParts[3].animDuration);
	    end;
	end;
	if InputBinding.hasEvent(InputBinding.Drzwi2) then
		if self.animationParts[4].clipEndTime then
			self:setAnimationTime(4, self.animationParts[4].offSet);
		elseif self.animationParts[4].clipStartTime then
			self:setAnimationTime(4, self.animationParts[4].animDuration);
	    end;
	  end;
	end;

	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(5, 1);
		else
			self:setAnimationTime(5, 0);
		end;
	end;

	if InputBinding.hasEvent(InputBinding.C360) then
		self.helpPanelActive = not self.helpPanelActive;
	end;

end;

function C360:updateTick(dt)
	if self:getIsActive() then
		if not self.finishWiper then
			if getAnimTrackTime(self.wiperAnimCharSet, 0) % self.wiperAnimDuration <= 100 then
				setAnimTrackTime(self.wiperAnimCharSet, 0, 0.0);
				disableAnimTrack(self.wiperAnimCharSet, 0);			
				self.finishWiper = true;
			end;			
		end;
		
		if self.backHydraulic ~= nil then
			-- set correct rotation on rootArm
			local x, y, z = getRotation(self.backHydraulic.bottomArm);
			setRotation(self.backHydraulic.rootArm, x, y, z);			
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.isWiperActive then
				enableAnimTrack(self.wiperAnimCharSet, 0);
				self.isWiperActive = true;
			end;
		else
			if self.isWiperActive then
				self.isWiperActive = false;
				self.finishWiper = false;
			end;
		end;
		
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;
	end;
end;

function C360:draw()  
   	if self.helpPanelActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("C360Off"), InputBinding.C360);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("C360On"), InputBinding.C360);
	end;
	if self.helpPanelOverlay ~= nil then
		if self.helpPanelActive then
			self.helpPanelOverlay:render();
		end;
	end;
	if self.helpPanelActive then
		if self.animationParts[1].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.775, 0.018, "Klawisz Num 4: Dach");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.775, 0.018, "Dach zamkniety");
		end;
		if self.animationParts[2].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.755, 0.018, "Tylna szyba zamknieta");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.755, 0.018, "Klawisz NUM 8: Tylna szyba");
		end;
		if self.animationParts[3].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.735, 0.018, "Klawisz NUM 7: Drzwi lewe");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.735, 0.018, "Drzwi zamkniete");
		end;
		if self.animationParts[4].clipStartTime then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.715, 0.018, "Klawisz NUM 9: Drzwi prawe");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.715, 0.018, "Drzwi zamkniete");
		end;
		if self.animationParts[6].clipStartTime then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.695, 0.018, "Maska zamknieta");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.695, 0.018, "Maska otwarta");
		end;
	end;
end;

function C360:onLeave()
	if self.isWiperActive then
		disableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;

function C360:onEnter()
	if self.isWiperActive then
		enableAnimTrack(self.wiperAnimCharSet, 0);	
	end;
end;
