TunnelAgricoloPlaceable = {};
TunnelAgricoloPlaceable.Dir = g_currentModDirectory;
TunnelAgricoloPlaceable_mt = Class(TunnelAgricoloPlaceable, Placeable);
InitObjectClass(TunnelAgricoloPlaceable, "TunnelAgricoloPlaceable");

function TunnelAgricoloPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, TunnelAgricoloPlaceable_mt);
    registerObjectClassName(self, "TunnelAgricoloPlaceable");
    return self;
end;

function TunnelAgricoloPlaceable:load(xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom)
    if not TunnelAgricoloPlaceable:superClass().load(self, xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom) then
        return false;
    end;
    local id = Utils.indexToObject(self.nodeId,"0");
    return true;
end;

function TunnelAgricoloPlaceable:delete()
    unregisterObjectClassName(self);
    TunnelAgricoloPlaceable:superClass().delete(self)
end;

function TunnelAgricoloPlaceable:readStream(streamId, connection)
    TunnelAgricoloPlaceable:superClass().readStream(self, streamId, connection)
end

function TunnelAgricoloPlaceable:writeStream(streamId, connection)
    TunnelAgricoloPlaceable:superClass().writeStream(self, streamId, connection)
end

function TunnelAgricoloPlaceable:deleteFinal()
    TunnelAgricoloPlaceable:superClass().deleteFinal(self)
end;

function TunnelAgricoloPlaceable:update(dt)      
end;

function TunnelAgricoloPlaceable:updateTick()    
end;

function TunnelAgricoloPlaceable:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    if not TunnelAgricoloPlaceable:superClass().loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles) then
        return false
    end;
    return true
end

function TunnelAgricoloPlaceable:getSaveAttributesAndNodes(nodeIdent)
    local attributes, nodes = TunnelAgricoloPlaceable:superClass().getSaveAttributesAndNodes(self, nodeIdent)
	return attributes, nodes
end
registerPlaceableType("TunnelAgricoloPlaceable", TunnelAgricoloPlaceable);