--
-- seedTrailer
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v1.0
-- @date:       2013-08-21
-- 
--[[
<seedTrailer trigger="">
	<bag index="" />
</seedTrailer>
]]--

seedTrailer = {};

function seedTrailer.prerequisitesPresent(specializations)
	if not SpecializationUtil.hasSpecialization(Fillable, specializations) then print("Warning: Specialization seedTrailer needs the specialization Fillable."); end;
	
	return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function seedTrailer:load(xmlFile)
	self.setIsFilling = seedTrailer.setIsFilling;
	self.addSowingMachineFillTrigger = seedTrailer.addSowingMachineFillTrigger;
	self.removeSowingMachineFillTrigger = seedTrailer.removeSowingMachineFillTrigger;
	
	self.triggerCallback = seedTrailer.triggerCallback;
	self.fillSowingMachine = seedTrailer.fillSowingMachine;
	self.getIsActivatable = seedTrailer.getIsActivatable;

	self.fillLitersPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fillLitersPerSecond"), 500);
	self.isFilling = false;

	self.seedFillTriggers = {};
	self.seedFillActivatable = seedTrailerFillActivatable:new(self);
	
	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, seedTrailer.setFillLevel);
	
	self.bags = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.seedTrailer.bag(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key .. "#index"));
		if node ~= nil then
			setVisibility(node, false);
			table.insert(self.bags, node);
		else
			print("Warning: bag index is nil in " .. self.configFileName);
		end;
		
		i = i + 1;
	end;
	
	self.seedBags = {};
	self.seedBags.num = table.getn(self.bags);
	self.seedBags.last = 0;
	
	local trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seedTrailer#trigger"));
	if trigger ~= nil then
		addTrigger(trigger, "triggerCallback", self);
		self.seedBags.trigger = trigger;
	end;
end;

function seedTrailer:delete()
	if self.seedBags.trigger ~= nil then
		removeTrigger(self.seedBags.trigger);
	end;
end;
  
function seedTrailer:readStream(streamId, connection)
	self:setIsFilling(streamReadBool(streamId), true);
end;

function seedTrailer:writeStream(streamId, connection)
	streamWriteBool(streamId, self.isFilling);
end;

function seedTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function seedTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function seedTrailer:update(dt)
end;

function seedTrailer:updateTick(dt)
	if self.isServer and self.isFilling then
		local delta = 0;
		
		if self.currentFillTrigger ~= nil then
			delta = self.fillLitersPerSecond * dt * 0.0001;
			delta = self.currentFillTrigger:fillSowingMachine(self, delta);
		end;

		if delta <= 0 then
			self:setIsFilling(false);
		end;
	end;
end;

function seedTrailer:draw()
end;

function seedTrailer:setIsFilling(isFilling, noEventSend)
	setIsFillingEvent.sendEvent(self, isFilling, noEventSend);
	
	if self.isFilling ~= isFilling then
		self.isFilling = isFilling;

		self.currentFillTrigger = nil;
		
		if isFilling then
			for i, trigger in ipairs(self.seedFillTriggers) do
				if trigger:getIsActivatable(self) then
					self.currentFillTrigger = trigger;
					break;
				end;
			end;
		end
	end;
end;

function seedTrailer:addSowingMachineFillTrigger(trigger)
	if table.getn(self.seedFillTriggers) == 0 then
		g_currentMission:addActivatableObject(self.seedFillActivatable);
	end;
	
	table.insert(self.seedFillTriggers, trigger);
end;

function seedTrailer:removeSowingMachineFillTrigger(trigger)
	for i = 1, table.getn(self.seedFillTriggers) do
		if self.seedFillTriggers[i] == trigger then
			table.remove(self.seedFillTriggers, i);
			break;
		end;
	end;
	
	if table.getn(self.seedFillTriggers) == 0 then
		if self.isServer then
			self:setIsFilling(false);
		end;
		
		g_currentMission:removeActivatableObject(self.seedFillActivatable);
	end;
end;

function seedTrailer:setFillLevel(superFunc, fillLevel, fillType, force)
	if self.seedBags.num > 0 then
		local visibleBags = math.ceil(self.seedBags.num * fillLevel / self.capacity);
		
		if self.seedBags.last ~= visibleBags then
			for i, node in pairs(self.bags) do
				setVisibility(node, i <= visibleBags);
			end;
			
			self.seedBags.last = visibleBags;
		end;
	end;
	
	if self:allowFillType(fillType, false) then
		fillType = Fillable.FILLTYPE_SEEDS;
	end;
	  
	superFunc(self, fillLevel, fillType, force);
end;

function seedTrailer:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter or onLeave then
		local sowingMachine = g_currentMission.objectToTrailer[otherShapeId];
	
		if sowingMachine ~= nil and sowingMachine.addSowingMachineFillTrigger ~= nil and sowingMachine.removeSowingMachineFillTrigger ~= nil and sowingMachine ~= self then
			if onEnter then
				sowingMachine:addSowingMachineFillTrigger(self);
			else
				sowingMachine:removeSowingMachineFillTrigger(self);
			end;
		end;
	end;
end;

function seedTrailer:fillSowingMachine(sowingMachine, delta)
	if not sowingMachine:allowFillType(self.currentFillType, false) then
		return 0;
	end;
	
	local oldFillLevel = sowingMachine:getFillLevel(self.currentFillType);
	local seedbags = self:getFillLevel(self.currentFillType);
	delta = math.min(delta, seedbags);
	
	if delta > 0 then
		sowingMachine:setFillLevel(oldFillLevel + delta, self.currentFillType, true);
		delta = sowingMachine:getFillLevel(self.currentFillType) - oldFillLevel;
		
		self:setFillLevel(seedbags - delta, self.currentFillType);
	end;

	return delta;
end;

function seedTrailer:getIsActivatable(fillable)
	if not fillable:allowFillType(self.currentFillType, false) or self.fillLevel <= 0 then
		return false;
	end;
	
	return true;
end;

---

seedTrailerFillActivatable = {}
local seedTrailerFillActivatable_mt = Class(seedTrailerFillActivatable);

function seedTrailerFillActivatable:new(seedTrailer)
	local self = {};
	setmetatable(self, seedTrailerFillActivatable_mt);

	self.seedTrailer = seedTrailer;
	self.activateText = "unknown";

	return self;
end;

function seedTrailerFillActivatable:getIsActivatable()
	if self.seedTrailer:getIsActiveForInput() and self.seedTrailer.fillLevel < self.seedTrailer.capacity then
		for i, trigger in ipairs(self.seedTrailer.seedFillTriggers) do
			if trigger:getIsActivatable(self.seedTrailer) then
				self:updateActivateText();
				return true;
			end;
		end;
	end;
	
	return false;
end;

function seedTrailerFillActivatable:onActivateObject()
	self.seedTrailer:setIsFilling(not self.seedTrailer.isFilling);
	self:updateActivateText();
	g_currentMission:addActivatableObject(self);
end;

function seedTrailerFillActivatable:drawActivate()
end;

function seedTrailerFillActivatable:updateActivateText()
	if self.seedTrailer.isFilling then
		self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.seedTrailer.typeDesc);
	else
		self.activateText = string.format(g_i18n:getText("refill_OBJECT"), self.seedTrailer.typeDesc);
	end;
end;

---

setIsFillingEvent = {};
setIsFillingEvent_mt = Class(setIsFillingEvent, Event);

InitEventClass(setIsFillingEvent, "setIsFillingEvent");

function setIsFillingEvent:emptyNew()
    local self = Event:new(setIsFillingEvent_mt);
    self.className = "setIsFillingEvent";
	
    return self;
end;

function setIsFillingEvent:new(object, isFilling)
    local self = setIsFillingEvent:emptyNew()
    self.object = object;
	self.isFilling = isFilling;
	
    return self;
end;

function setIsFillingEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isFilling = streamReadBool(streamId);
    self.object = networkGetObject(id);
	
    self:run(connection);
end;

function setIsFillingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isFilling);
end;

function setIsFillingEvent:run(connection)
	self.object:setIsFilling(self.isFilling, true);
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(setIsFillingEvent:new(self.object, self.isFilling), nil, connection, self.object);
	end;
end;

function setIsFillingEvent.sendEvent(object, isFilling, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setIsFillingEvent:new(object, isFilling), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(setIsFillingEvent:new(object, isFilling));
		end;
	end;
end;