
function TrafficVehicle:load(xmlFile)
  self.justStarted = true
  self.isSunOn = false
  self.isNiceWeather = false
  self.lightsId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lights#groupIndex"))
  self.lightsId2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightsPrizep#groupIndex"))
  self.lightsId3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.lightsPrizepMTZ#groupIndex"))
  local colorNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.colors#index"))
  if colorNode ~= nil then
    local colors = {}
    table.insert(colors, {1,1,1})
    local i = 0
    while true do
        local key = string.format("vehicle.colors.color(%d)", i)
        local rgb = getXMLString(xmlFile, key .. "#rbg")
        if rgb == nil then
          break
        end
        local r, g, b = Utils.getVectorFromString(rgb)
        if r ~= nil and g ~= nil and b ~= nil then
          table.insert(colors, {r,g,b})
        end
        i = i + 1
    end
    local index = math.random(1, table.getn(colors))
    setShaderParameter(colorNode, "partScale", colors[index][1], colors[index][2], colors[index][3], 0, false)
  end

    if Utils.endsWith(self.configFileName, "/TrafficPack/KamAZ6460/KamAZ6460.xml") then
		self.motorSound1 = Utils.getFilename("Sourse/KamAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound1, 25, 3, 2, 0);

    elseif Utils.endsWith(self.configFileName, "/TrafficPack/KamAZ6460/KamAZ6460Pricep.xml") then	
		self.motorSound2 = Utils.getFilename("Sourse/KamAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound2, 25, 3, 2, 0);
		
    elseif Utils.endsWith(self.configFileName, "/TrafficPack/KamAZ6520/KamAZ6520.xml") then	
		self.motorSound3 = Utils.getFilename("Sourse/KamAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound3, 25, 3, 2, 0);
		
    elseif Utils.endsWith(self.configFileName, "/TrafficPack/KamAZ6520/KamAZ6520P.xml") then	
		self.motorSound4 = Utils.getFilename("Sourse/KamAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound4, 25, 3, 2, 0);
		
    elseif Utils.endsWith(self.configFileName, "/TrafficPack/KamAZ6520/KamAZ6520S.xml") then	
		self.motorSound5 = Utils.getFilename("Sourse/KamAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound5, 25, 3, 2, 0);
		
    elseif Utils.endsWith(self.configFileName, "/TrafficPack/ZiL4331/ZiL4331.xml") then	
		self.motorSound6 = Utils.getFilename("Sourse/ZiL.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound6, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/ZiL4331/ZiL4331S.xml") then	
		self.motorSound7 = Utils.getFilename("Sourse/ZiL.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound7, 25, 2, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/ZiL4331/ZiL4331G.xml") then	
		self.motorSound8 = Utils.getFilename("Sourse/ZiL.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound8, 25, 2, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/ZiL4331/ZiL4331K.xml") then	
		self.motorSound9 = Utils.getFilename("Sourse/ZiL.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound9, 25, 2, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/ZiL4331/ZiL4331V.xml") then	
		self.motorSound10 = Utils.getFilename("Sourse/ZiL.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound10, 25, 2, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/GAZ2705S/GAZ2705S.xml") then	
		self.motorSound11 = Utils.getFilename("Sourse/GAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound11, 25, 3, 2, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/GAZ3110/GAZ3110.xml") then	
		self.motorSound12 = Utils.getFilename("Sourse/GAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound12, 25, 3, 2, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/GAZ3302/GAZ3302.xml") then	
		self.motorSound13 = Utils.getFilename("Sourse/GAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound13, 25, 3, 2, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/GAZ322132/GAZ322132.xml") then	
		self.motorSound14 = Utils.getFilename("Sourse/GAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound14, 25, 3, 2, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2106/VAZ2106.xml") then	
		self.motorSound15 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound15, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2106/VAZ2106C.xml") then	
		self.motorSound16 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound16, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2106/VAZ2106DPS.xml") then	
		self.motorSound17 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound17, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2106/VAZ2106M4C.xml") then	
		self.motorSound18 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound18, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2107/VAZ2107.xml") then	
		self.motorSound19 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound19, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2109/VAZ2109.xml") then	
		self.motorSound20 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound20, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2110/VAZ2110.xml") then	
		self.motorSound21 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound21, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2110/VAZ2110C.xml") then	
		self.motorSound22 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound22, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/VAZ2110/VAZ2110M4S.xml") then	
		self.motorSound23 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound23, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/Niva/Niva.xml") then	
		self.motorSound24 = Utils.getFilename("Sourse/VAZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound24, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/MTZ80/MTZ80.xml") then	
		self.motorSound25 = Utils.getFilename("Sourse/MTZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound25, 25, 3, 1, 0);

	elseif Utils.endsWith(self.configFileName, "/TrafficPack/MTZ80/MTZ80PLN335.xml") then	
		self.motorSound26 = Utils.getFilename("Sourse/MTZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound26, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/MTZ80/MTZ80Krone.xml") then	
		self.motorSound27 = Utils.getFilename("Sourse/MTZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound27, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/MTZ80/MTZ80KroneG.xml") then	
		self.motorSound28 = Utils.getFilename("Sourse/MTZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound28, 25, 3, 1, 0);
		
	elseif Utils.endsWith(self.configFileName, "/TrafficPack/MTZ80/MTZ80KroneW.xml") then	
		self.motorSound29 = Utils.getFilename("Sourse/MTZ.wav", self.baseDirectory)
		self.soundId = createAudioSource("trafficSample", self.motorSound29, 25, 3, 1, 0);
	else
		self.soundId = createAudioSource("trafficSample", "data/vehicles/cars/carSound.wav", 25, 2, 1, 0) --     
	end	
	link(self.components[1].node, self.soundId);	
end
function TrafficVehicle:delete()
end
function TrafficVehicle:mouseEvent(posX, posY, isDown, isUp, button)
end
function TrafficVehicle:keyEvent(unicode, sym, modifier, isDown)
end
function TrafficVehicle:update(dt)
    if self.justStarted or self.isSunOn ~= g_currentMission.environment.isSunOn or self.isNiceWeather ~= (g_currentMission.environment.currentRain == nil) then
        self.isSunOn = g_currentMission.environment.isSunOn;
		self.isNiceWeather = g_currentMission.environment.currentRain == nil;
		self.justStarted = false;
        setVisibility(self.lightsId, not (self.isSunOn and self.isNiceWeather)); 
        setVisibility(self.lightsId2, not (self.isSunOn and self.isNiceWeather));
        setVisibility(self.lightsId3, not (self.isSunOn and self.isNiceWeather));
    end;
end
function TrafficVehicle:draw()
end