-- by modelleicher
-- www.schwabemmodding.bplaced.net
imgBasedHud = {};

function imgBasedHud.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function imgBasedHud:load(xmlFile)
	self.imgBasedHudCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.imgBasedHud#hudsCount"));
	self.imgHuds = {};
	for i=1, self.imgBasedHudCount do
	local localpath = string.format("vehicle.imgBasedHud.Hud%d", i)
		local imgHudPart = {};
		imgHudPart.imgPath = Utils.getNoNil(getXMLString(xmlFile, localpath .. "#imgPath"));
		imgHudPart.imgPosX = Utils.getNoNil(getXMLFloat(xmlFile, localpath .. "#posX"));
		imgHudPart.imgPosY = Utils.getNoNil(getXMLFloat(xmlFile, localpath .. "#posY"));
		imgHudPart.imgScaleX = Utils.getNoNil(getXMLFloat(xmlFile, localpath .. "#scaleX"));
		imgHudPart.imgScaleY = Utils.getNoNil(getXMLFloat(xmlFile, localpath .. "#scaleY"));
		imgHudPart.imgOverlay = Overlay:new("imgOverlay"..i, Utils.getFilename(imgHudPart.imgPath, self.baseDirectory), imgHudPart.imgPosX, imgHudPart.imgPosY, imgHudPart.imgScaleX, imgHudPart.imgScaleY);
		imgHudPart.imgOn = false;
		table.insert(self.imgHuds, imgHudPart);
	end;
	self.currentHud = 0;
end;
function imgBasedHud:delete()
end;
function imgBasedHud:readStream(streamId, connection)   
end;
function imgBasedHud:writeStream(streamId, connection)  
end;
function imgBasedHud:mouseEvent(posX, posY, isDown, isUp, button)
end;
function imgBasedHud:keyEvent(unicode, sym, modifier, isDown)
end;
function imgBasedHud:update(dt)	
	if self:getIsActive() then	
		if InputBinding.hasEvent(InputBinding.IMGBASEDHUD) then
			if self.currentHud < self.imgBasedHudCount then
				self.currentHud = self.currentHud +1
			elseif self.currentHud == self.imgBasedHudCount then
				self.currentHud = 0;
			end;
		end;
	end;
end;
function imgBasedHud:draw()
	if self.currentHud > 0 then
		if self.imgBasedHudCount > 1 and self.currentHud < self.imgBasedHudCount then
			g_currentMission:addExtraPrintText(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMGBASEDHUD).."      Hud weiterschalten")	
		else
			g_currentMission:addExtraPrintText(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMGBASEDHUD).."                                    Info off")	
		end;
		self.imgHuds[self.currentHud].imgOverlay:render();
	else
		g_currentMission:addExtraPrintText(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.IMGBASEDHUD).."                                    Info on")		
	end;
end;
