--
-- variableCapacity
-- This Specialization is for a variable capacity
--
-- @author  Stefan Maurus	
-- @date  20/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de


variableCapacity = {};

function variableCapacity.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function variableCapacity:load(xmlFile)	
	self.maxDifference = 100;
	self.capacityHasChanged = false;
	self.capacityBackup = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0);
end;

function variableCapacity:delete()
end;

function variableCapacity:mouseEvent(posX, posY, isDown, isUp, button)
end;

function variableCapacity:keyEvent(unicode, sym, modifier, isDown)
end;

function variableCapacity:update(dt)
end;

function variableCapacity:updateTick(dt)
	if not self.capacityHasChanged then
		self.capacityHasChanged = true;
		local randomVariable = math.random(self.maxDifference);
		local randomFactor = math.random(1,2);
		if randomFactor == 1 then
			self.capacity = self.capacityBackup-randomVariable;		
		elseif randomFactor == 2 then
			self.capacity = self.capacityBackup+randomVariable;		
		end;
	end;
	if self.fillLevel == 0 and self.capacityHasChanged then
		self.capacityHasChanged = false;
	end;	
end;

function variableCapacity:onAttach()	
end;

function variableCapacity:onDetach()	
end;

function variableCapacity:draw()
end;

function variableCapacity:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentCapacity = getXMLInt(xmlFile, key .. "#currentCapacity");
	if currentCapacity ~= nil then
		self.capacity = currentCapacity;	
	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;
 
function variableCapacity:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentCapacity="' .. self.capacity .. '" ';
	return attributes;
end;