--
-- AloeFlexibal
-- Specialization for  Aloe Flexibal
--
-- @author  Stefan Maurus	
-- @date  06/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

AloeFlexibal = {};

function AloeFlexibal.prerequisitesPresent(specializations)
    return true;
end;

function AloeFlexibal:load(xmlFile)	
	self.setWrapBalesState = SpecializationUtil.callSpecializationsFunction("setWrapBalesState"); 
	
    self.wrapBalesLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wrapBales#left"));
    self.wrapBalesRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wrapBales#right"));
	self.wrapBalesState = 0;
end;

function AloeFlexibal:delete()
end;

function AloeFlexibal:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AloeFlexibal:keyEvent(unicode, sym, modifier, isDown)
end;

function AloeFlexibal:readStream(streamId, connection)
	self:setWrapBalesState(streamReadInt8(streamId), true); 
end;

function AloeFlexibal:writeStream(streamId, connection) 
	streamWriteInt8(streamId, self.wrapBalesState); 
end;

function AloeFlexibal:setWrapBalesState(int, noEventSend)
	self.wrapBalesState = int;
	setWrapBalesStateEvent.sendEvent(self, int, noEventSend);
end;

function AloeFlexibal:update(dt)	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.wrapBalesState == 0 then
				self:setWrapBalesState(1);
			elseif self.wrapBalesState == 1 then
				self:setWrapBalesState(0);
			end;
		end;	
	end;
	
	if self.wrapBalesState == 0 then
		setVisibility(self.wrapBalesLeft, true);
		setVisibility(self.wrapBalesRight, true);		
	elseif self.wrapBalesState == 1 then
		setVisibility(self.wrapBalesLeft, false);
		setVisibility(self.wrapBalesRight, false);		
	end;	
end;

function AloeFlexibal:updateTick(dt)
end;

function AloeFlexibal:onAttach()	
end;

function AloeFlexibal:onDetach()		
end;

function AloeFlexibal:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ALOE_FLEXIBAL_SWITCH"), InputBinding.IMPLEMENT_EXTRA2);
end;

setWrapBalesStateEvent = {};
setWrapBalesStateEvent_mt = Class(setWrapBalesStateEvent, Event);

InitEventClass(setWrapBalesStateEvent, "setWrapBalesStateEvent");

function setWrapBalesStateEvent:emptyNew()
    local self = Event:new(setWrapBalesStateEvent_mt);
    self.className="setWrapBalesStateEvent";
    return self;
end;

function setWrapBalesStateEvent:new(vehicle, wrapBalesState)
    local self = setWrapBalesStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.wrapBalesState = wrapBalesState;
    return self;
end;

function setWrapBalesStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.wrapBalesState = streamReadInt8(streamId);
	self.vehicle:setWrapBalesState(self.wrapBalesState, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(setWrapBalesStateEvent:new(self.vehicle, self.wrapBalesState), nil, connection, self.vehicle);
    end;
end;

function setWrapBalesStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.wrapBalesState);
end;

function setWrapBalesStateEvent.sendEvent(vehicle, wrapBalesState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setWrapBalesStateEvent:new(vehicle, wrapBalesState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setWrapBalesStateEvent:new(vehicle, wrapBalesState));
		end;
	end;
end;