--
-- AloeBalefork
-- Specialization for  Aloe Ballengabel
--
-- @author  Stefan Maurus	
-- @date  03/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

AloeBalefork = {};

function AloeBalefork.prerequisitesPresent(specializations)
    return true;
end;

function AloeBalefork:load(xmlFile)
	self.setForkState = SpecializationUtil.callSpecializationsFunction("setForkState"); 

    self.forkSwitch = getXMLString(xmlFile, "vehicle.forkSwitch#name");
	self.forkState = 0;
end;

function AloeBalefork:readStream(streamId, connection)
	self:setForkState(streamReadInt8(streamId), true); 
end;

function AloeBalefork:writeStream(streamId, connection) 
	streamWriteInt8(streamId, self.forkState); 
end;

function AloeBalefork:setForkState(int, noEventSend)
	self.forkState = int;
	SetForkStateEvent.sendEvent(self, int, noEventSend);
end;

function AloeBalefork:delete()
end;

function AloeBalefork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AloeBalefork:keyEvent(unicode, sym, modifier, isDown)
end;

function AloeBalefork:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			if self.forkState == 0 then
				self:setForkState(self.forkState+1);
			elseif self.forkState == 1 then
				self:setForkState(self.forkState-1);
			end;
		end;	
	end;
end;

function AloeBalefork:updateTick(dt)
	if self.forkState == 0 then
		self:playAnimation(self.forkSwitch, -1, nil, true);
	elseif self.forkState == 1 then
		self:playAnimation(self.forkSwitch, 1, nil, true);	
	end;	
end;

function AloeBalefork:onAttach()
end;

function AloeBalefork:onDetach()	
end;

function AloeBalefork:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ALOE_BALEFORK_SWITCH"), InputBinding.IMPLEMENT_EXTRA2);
end;


SetForkStateEvent = {};
SetForkStateEvent_mt = Class(SetForkStateEvent, Event);

InitEventClass(SetForkStateEvent, "SetForkStateEvent");

function SetForkStateEvent:emptyNew()
    local self = Event:new(SetForkStateEvent_mt);
    self.className="SetForkStateEvent";
    return self;
end;

function SetForkStateEvent:new(vehicle, forkState)
    local self = SetForkStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.forkState = forkState;
    return self;
end;

function SetForkStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.forkState = streamReadInt8(streamId);
	self.vehicle:setForkState(self.forkState, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetForkStateEvent:new(self.vehicle, self.forkState), nil, connection, self.vehicle);
    end;
end;

function SetForkStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.forkState);
end;


function SetForkStateEvent.sendEvent(vehicle, forkState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetForkStateEvent:new(vehicle, forkState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetForkStateEvent:new(vehicle, forkState));
		end;
	end;
end;