
SpeedLimiter = {};

function SpeedLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function SpeedLimiter:load(xmlFile)

	--selfs
	self.tacho = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.tacho#index"));
	setVisibility(self.tacho, false);
	self.speed1 = 0;
	self.speed2 = 0;
	self.speed3 = 0;
	self.speedMode = 1;
	-- HUD --

	self.HUDpath = Utils.getFilename("HUD.png", self.baseDirectory);
	self.HUDWidth = 0.100;
    self.HUDHeight = 0.22;
	self.HUDPoxX = 0.90;
    self.HUDPoxY = 0.165
    self.HUDOverlay = Overlay:new("HUD", self.HUDpath, self.HUDPoxX, self.HUDPoxY, self.HUDWidth, self.HUDHeight);



end;

function SpeedLimiter:delete()
if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;


end;

function SpeedLimiter:readStream(streamId, connection)
end;

function SpeedLimiter:writeStream(streamId, connection)
end;

function SpeedLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SpeedLimiter:keyEvent(unicode, sym, modifier, isDown)

end;

function SpeedLimiter:update(dt)

	-- SpeedModeSelection
	if self.isMotorStarted and self:getIsActiveForInput() then
	if InputBinding.hasEvent(InputBinding.SPEEDMODEPLUS) then
	self.speedMode = self.speedMode + 1;
	elseif InputBinding.hasEvent(InputBinding.SPEEDMODEMINUS) then
	self.speedMode = self.speedMode - 1;
	end
	if self.speedMode < 1 then
	self.speedMode = 3;
	elseif
	self.speedMode > 3 then
	self.speedMode = 1
	end;
	end;


	-- SpeedSelection --
	-- SPEED 1 --
	if self.isMotorStarted and self:getIsActiveForInput() and self.speedMode == 1 then
	if InputBinding.hasEvent(InputBinding.SPEEDPLUS) then
	self.speed1 = self.speed1 + 0.2
	elseif
	 InputBinding.hasEvent(InputBinding.SPEEDMINUS) then
	self.speed1 = self.speed1 - 0.2
	end;
	if self.speed1 > 14 then
	self.speed1 = 14;
	elseif self.speed1 < 0 then
	self.speed1 = 0;
	end;
	end;

	-- SPEED 2 --

	if self.isMotorStarted and self:getIsActiveForInput() and self.speedMode == 2 then
	if InputBinding.hasEvent(InputBinding.SPEEDPLUS) then
	self.speed2 = self.speed2 + 0.2
	elseif
	 InputBinding.hasEvent(InputBinding.SPEEDMINUS) then
	self.speed2 = self.speed2 - 0.2
	end;
	if self.speed2 > 25 then
	self.speed2 = 25;
	elseif self.speed2 < self.speed1 then
	self.speed2 = math.ceil(self.speed1*1.25);
	end;
	end;

	-- SPEED 3 --

	if self.isMotorStarted and self:getIsActiveForInput() and self.speedMode == 3 then
	if InputBinding.hasEvent(InputBinding.SPEEDPLUS) then
	self.speed3 = self.speed3 + 0.2
	elseif
	 InputBinding.hasEvent(InputBinding.SPEEDMINUS) then
	self.speed3 = self.speed3 - 0.2
	end;
	if self.speed3 > 50 then
	self.speed3 = 50;
	elseif self.speed3 < self.speed2 then
	self.speed3 = math.ceil(self.speed2*1.25);
	end;
	end;

		if self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			if InputBinding.hasEvent(InputBinding.SLPLUS) then
			self.motor.speedLevel = self.motor.speedLevel + 1;
			if self.motor.speedLevel > 3 then
			self.motor.speedLevel = 3;
			end;
			end;
			if InputBinding.hasEvent(InputBinding.SLMINUS) then
			self.motor.speedLevel = self.motor.speedLevel - 1;
			if self.motor.speedLevel < 0 then
			self.motor.speedLevel = 0;
			end;
			end;
		end;


--Speed_Limiter--


	if self.motor.speedLevel == 1 then
	self.motor.realSpeedLevels[self.motor.speedLevel] = self.speed1 - (1.396-(0.02778*self.realGroundSpeed * 3.6));
	elseif self.motor.speedLevel == 2 then
	self.motor.realSpeedLevels[self.motor.speedLevel] = self.speed2 - (1.396-(0.02778*self.realGroundSpeed * 3.6));
	elseif self.motor.speedLevel == 3 then
	self.motor.realSpeedLevels[self.motor.speedLevel] = self.speed3 - (1.396-(0.02778*self.realGroundSpeed * 3.6));
	end;



	if self.isMotorStarted then
		setVisibility(self.tacho, true);
	else
		setVisibility(self.tacho, false);
	end;

end;
function SpeedLimiter:updateTick(dt)

end;
function SpeedLimiter:draw()

	if self.isMotorStarted then
		if self.HUDOverlay ~= nil then
				self.HUDOverlay:render();
				setTextBold(false);
				setTextColor(0, 0, 0, 1.0);
				renderText(0.975, 0.22, 0.0250,string.format("%d ",self.realGroundSpeed*3.6).."km/h");

				if self.speedMode == 1 then
				setTextColor(1, 0, 0, 1.0);
				renderText(0.96, 0.2545, 0.0250,string.format("%g ",self.speed1));
				elseif self.motor.speedLevel == 1 then
				setTextColor(0, 1, 0, 1.0);
				renderText(0.96, 0.2545, 0.0250,string.format("%g ",self.speed1));
				else
				setTextColor(0, 0, 0, 1.0);
				renderText(0.96, 0.2545, 0.0250,string.format("%g ",self.speed1));
				end;

				if self.speedMode == 2 then
				setTextColor(1, 0, 0, 1.0);
				renderText(0.96, 0.2745, 0.0250,string.format("%g ",self.speed2));
				elseif self.motor.speedLevel == 2 then
				setTextColor(0, 1, 0, 1.0);
				renderText(0.96, 0.2745, 0.0250,string.format("%g ",self.speed2));
				else
				setTextColor(0, 0, 0, 1.0);
				renderText(0.96, 0.2745, 0.0250,string.format("%g ",self.speed2));
				end;


				if self.speedMode == 3 then
				setTextColor(1, 0, 0, 1.0);
				renderText(0.96, 0.2945, 0.0250,string.format("%g ",self.speed3));
				elseif self.motor.speedLevel == 3 then
				setTextColor(0, 1, 0, 1.0);
				renderText(0.96, 0.2945, 0.0250,string.format("%g ",self.speed3));
				else
				setTextColor(0, 0, 0, 1.0);
				renderText(0.96, 0.2945, 0.0250,string.format("%g ",self.speed3));
				end;


		end;
	end;
end;


function SpeedLimiter:stopMotor()
end;




