-- by "Marhu" 
-- v 2.0
-- Date: 19.03.2013
-- Neu Positionirung der Eier in Hnerstall mit Ostern Mod

local OD = {[13]={[3]={[29]=1,[30]=1,[31]=1},[4]={[1]=1}},
			[14]={[4]={[18]=1,[19]=1,[20]=1,[21]=1}},
			[15]={[4]={[3]=1,[4]=1,[5]=1,[6]=1}},
			[16]={[3]={[25]=1,[26]=1,[27]=1,[28]=1}}}
	
Huehnerstall = {};
Huehnerstall_mt = Class(Huehnerstall, Placeable);
InitObjectClass(Huehnerstall, "Huehnerstall");

function Huehnerstall:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, Huehnerstall_mt);
    registerObjectClassName(self, "Huehnerstall");
	
	return self;
end;

function Huehnerstall:delete()
    if self.TuerTrigger then
		removeTrigger(self.TuerTrigger);
	end;
	
	if self.pos and g_currentMission then
		if g_currentMission.EggsInChickenCoop then
			for nodeID, v in pairs(g_currentMission.EggsInChickenCoop) do
				if v.Coop == self.nodeId then
					local trigger = getChildAt(nodeID,0);
					setRigidBodyType(trigger, "NoRigidBody")
					setTranslation(nodeID, unpack(v.pos))
					setRigidBodyType(trigger, "Static")
					g_currentMission.EggsInChickenCoop[nodeID] = nil
				end;
			end;
		end;
		if g_currentMission.NumChickenCoops then g_currentMission.NumChickenCoops = math.max(0, g_currentMission.NumChickenCoops - 1) end;
		if g_currentMission.ChickenCoopsSetEggs then g_currentMission.ChickenCoopsSetEggs = 0 end;
	end;
	
	unregisterObjectClassName(self);
    Huehnerstall:superClass().delete(self);
end;

function Huehnerstall:deleteFinal()
    Huehnerstall:superClass().deleteFinal(self);
end;

function Huehnerstall:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not Huehnerstall:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	
	if not moveMode then
	
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
		self.TuerTrigger = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.TuerTrigger#index"));
		Barrier:onCreate(self.TuerTrigger)
		
		local start = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#start"));
		self.start = {getTranslation(start)}
		local widht = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#widht"));
		self.widht = {getTranslation(widht)}
		local height = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EggPos#height"));
		self.height = {getTranslation(height)}
			
		self.Glucke = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.Glucke#index"));
		self.EasterEggs = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.EasterEggs#index"));
		
		delete(xmlFile);
			
		self.pos = {x,y,z}
		self.rotX = {localDirectionToWorld(self.nodeId, 1, 0, 0)}
		self.rotY = {localDirectionToWorld(self.nodeId, 0, 1, 0)}
		self.rotZ = {localDirectionToWorld(self.nodeId, 0, 0, 1)}
		
		if not g_currentMission.EggsInChickenCoop then g_currentMission.EggsInChickenCoop = {} end;
		g_currentMission.NumChickenCoops = (g_currentMission.NumChickenCoops or 0) + 1
		g_currentMission.ChickenCoopsSetEggs = 0
		
	end
  
	return true;
end;

function Huehnerstall:update(dt)
	
	if not self.ShowGlucke then
		if g_currentMission.husbandries.chicken.numAnimals[0] >= 10 then
			setVisibility(self.Glucke, true);
			self.ShowGlucke = true
		end
	end
	
	if g_currentMission.ChickenCoopsSetEggs < g_currentMission.NumChickenCoops then
		g_currentMission.ChickenCoopsSetEggs = g_currentMission.ChickenCoopsSetEggs + 1
		
		local d,m,y=tonumber(getDate("%d")),tonumber(getDate("%m")),tonumber(getDate("%y"))
		local Eastern = false
		if OD[y] and OD[y][m] and OD[y][m][d] then
			print("Huehnerstall in Oster Mod")
			Eastern = true
			setVisibility(getChildAt(self.EasterEggs,0),true)
		end
			
		local ObjectsId = g_currentMission.husbandries.chicken.pickupObjectsId
		local EggGroup = {getWorldTranslation(ObjectsId)}
			
		local Num = getNumOfChildren(g_currentMission.husbandries.chicken.pickupObjectsId)
		local EggS = math.floor((Num / g_currentMission.NumChickenCoops) * (g_currentMission.ChickenCoopsSetEggs - 1)) + 1
		local EggE = math.floor((Num / g_currentMission.NumChickenCoops) * g_currentMission.ChickenCoopsSetEggs)

		for i = 1, Num do
			local child = getChildAt(ObjectsId, i-1);
			local toNear = false
			if Eastern then
				local wx,wy,wz = getWorldTranslation(child)
				toNear = Utils.vector3Length(self.pos[1]-wx, self.pos[2]-wy, self.pos[3]-wz) <= 4;
			end
			if (i >= EggS and i <= EggE) or toNear then
				if not g_currentMission.EggsInChickenCoop[child] then
					local Epos = {getTranslation(child)}
					g_currentMission.EggsInChickenCoop[child] = {Coop = self.nodeId,pos = Epos}
				else
					g_currentMission.EggsInChickenCoop[child].Coop = self.nodeId
				end
								
				if Eastern then
					local EasterEgg = clone(getChildAt(self.EasterEggs,((i % 6)+1)), true)
					setVisibility(EasterEgg,true)
					link(child,EasterEgg)
				end
				if not Eastern or toNear then
					local trigger = getChildAt(child,0);
					setRigidBodyType(trigger, "NoRigidBody")
										
					local zOff = math.random( 0, (self.widht[3]- self.start[3])*100 ) -- Verteilung
					local xOff = math.random( 0, (self.widht[1]- self.start[1])*100 )
					zOff = (zOff/100) + self.start[3]
					xOff = (xOff/100) + self.start[1]
					local x2 = self.pos[1] - (self.rotZ[1] * zOff) -- ZPos
					local z2 = self.pos[3] - (self.rotZ[3] * zOff)
					x2 = x2 + (self.rotX[1] * xOff) -- XPos
					z2 = z2 + (self.rotX[3] * xOff)
					local y2 = self.pos[2]
					local yOff = math.random( 0, 100 ) -- Oben/Unten
					if yOff >= 50 then
						y2 = y2 + (self.rotY[2] * self.height[2]) --YPos
					else
						y2 = y2 + (self.rotY[2] * self.start[2])
					end;
					
					local lx,ly,lz = worldToLocal(ObjectsId,x2,y2,z2)
							
					setTranslation(child, lx,ly,lz)
					setRigidBodyType(trigger, "Static")
				end;
			
			end;
		end;
	end;

end;

registerPlaceableType("Huehnerstall", Huehnerstall);