--
-- SampleModMap
--
-- @author  Getsome2030
-- @date  23/05/13
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    -- nonseedable
    FruitUtil.registerFruitType("sand", g_i18n:getText("sand"), false, false, false, 0, 4, 6, 8, false, 0.75, 3, 0.05, true, Utils.getFilename("huds/sandhud.dds", baseDirectory), {1,1,1,1});
	local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/The_Lake_v3Sand.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("The_Lake_v3.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -371, 444.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -46.9, -537.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -360, 425, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -57, -537.5, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -272, 695, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- egg sellpoints
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -117, -530, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Eggs", Utils.getFilename("$dataS/missions/hud_pda_spot_eggs.png", self.baseDirectory), -196, 685, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 220, -678, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 35, 668, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 105, -644, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 430, -578, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -313, 285, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 430, -615, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory), 350, -665, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 230, -585, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- spinnery
    g_currentMission.missionPDA:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS/missions/hud_pda_spot_spinnery.png", self.baseDirectory), 644, 411, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

	-- Wasser
    self.missionPDA:createMapHotspot("watersymbol", Utils.getFilename("huds/watersymbol.png", self.baseDirectory), 427, -151, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("watersymbol", Utils.getFilename("huds/watersymbol.png", self.baseDirectory), -83, -406, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("watersymbol", Utils.getFilename("huds/watersymbol.png", self.baseDirectory), -315, 511, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Mist
    self.missionPDA:createMapHotspot("misthaufensymbol", Utils.getFilename("huds/misthaufensymbol.png", self.baseDirectory),-335,  246, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Schwein
    self.missionPDA:createMapHotspot("schweinesymbol", Utils.getFilename("huds/schweinesymbol.png", self.baseDirectory), 581, -793, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	self.missionPDA:createMapHotspot("schweinesymbol", Utils.getFilename("huds/schweinesymbol.png", self.baseDirectory), 444,  730, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
	-- Sand
    self.missionPDA:createMapHotspot("sandsymbol", Utils.getFilename("huds/sandsymbol.png", self.baseDirectory), -390, -322, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
	
    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;