--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

floodLightPlaceable = {};
floodLightPlaceable_mt = Class(floodLightPlaceable, Placeable);
InitObjectClass(floodLightPlaceable, "floodLightPlaceable");

function floodLightPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, floodLightPlaceable_mt);
    registerObjectClassName(self, "floodLightPlaceable");
    return self;
end;

function floodLightPlaceable:delete()
    removeTrigger(self.stateChange);
    unregisterObjectClassName(self);
    floodLightPlaceable:superClass().delete(self);
end;

function floodLightPlaceable:deleteFinal()
    floodLightPlaceable:superClass().deleteFinal(self);
end;

function floodLightPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not floodLightPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    self.light = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.LightSettings.light#index"));
    self.Sublight = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.LightSettings.Sublight#index"));
    self.stateChange = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.LightSettings.stateChange#index"));
    addTrigger(self.stateChange,"triggerCallback",self);
    setVisibility(self.light,false);
    setVisibility(self.Sublight,false);
    self.lightEnabled = false;
    self.changeAllowed = false;
    self.UpdateDistance = 0;
    self.userCounter = 0;
    delete(xmlFile);
    return true;
end;

function floodLightPlaceable:update(dt)
    if g_server ~= nil then
        local playerCount = 0;
		for _,_ in pairs(g_currentMission.players) do
			playerCount = playerCount + 1;
		end;
        if (playerCount ~= self.userCounter) then
            SetFloodlightStateEvent.sendEvent(self, self.lightEnabled);
            self.userCounter = playerCount;
        end;
    end;
    self.UpdateDistance = (self.UpdateDistance+1);
    if self.changeAllowed then
        if self.lightEnabled then
            g_currentMission:addHelpButtonText(g_i18n:getText("DISABLE_PLACEABLE_LIGHT"), InputBinding.JUMP);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("ENABLE_PLACEABLE_LIGHT"), InputBinding.JUMP);
        end;
        if InputBinding.hasEvent(InputBinding.JUMP) then
            self:SetFloodlightState(not self.lightEnabled);
        end;
    end;
    if self.UpdateDistance > 35 then
        local nearestDistance = 100.0;
        if g_currentMission.controlledVehicle ~= nil then
            local px, py, pz = getWorldTranslation(self.nodeId);
            local vx, vy, vz = getWorldTranslation(g_currentMission.controlledVehicle.components[1].node);
            local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
            if distance < nearestDistance then
                if (self.lightEnabled and not getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,true);
                end;
            else
                if (self.lightEnabled and getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,false);
                end;
            end;
        elseif g_currentMission.player ~= nil then
            local px, py, pz = getWorldTranslation(self.nodeId);
            local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
            local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
            if distance < nearestDistance then
                if (self.lightEnabled and not getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,true);
                end;
            else
                if (self.lightEnabled and getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,false);
                end;
            end;
        end;
        self.UpdateDistance = 0;
    end;
end;

function floodLightPlaceable:triggerCallback(triggerId,otherId,onEnter,onLeave,onStay)
    if (triggerId == self.stateChange) then
        if (onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode) then
            self.changeAllowed = true;
        elseif (onLeave) then
            self.changeAllowed = false;
        end;
    end;
end;

function floodLightPlaceable:SetFloodlightState(state,mp)
    self.lightEnabled = state;
    setVisibility(self.light,state);
    setVisibility(self.Sublight,state);
    if state then
        local nearestDistance = 100.0;
        if g_currentMission.controlledVehicle ~= nil then
            local px, py, pz = getWorldTranslation(self.nodeId);
            local vx, vy, vz = getWorldTranslation(g_currentMission.controlledVehicle.components[1].node);
            local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
            if distance < nearestDistance then
                if (self.lightEnabled and not getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,true);
                end;
            else
                if (self.lightEnabled and getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,false);
                end;
            end;
        elseif g_currentMission.player ~= nil then
            local px, py, pz = getWorldTranslation(self.nodeId);
            local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
            local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
            if distance < nearestDistance then
                if (self.lightEnabled and not getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,true);
                end;
            else
                if (self.lightEnabled and getVisibility(self.Sublight)) then
                    setVisibility(self.light,true);
                    setVisibility(self.Sublight,false);
                end;
            end;
        end;
        self.UpdateDistance = 0;
    end;
    if mp == nil then
        SetFloodlightStateEvent.sendEvent(self, state);
    end;
end;
registerPlaceableType("floodlightplaceable", floodLightPlaceable);

SetFloodlightStateEvent = {};
SetFloodlightStateEvent_mt = Class(SetFloodlightStateEvent, Event);
InitEventClass(SetFloodlightStateEvent, "SetFloodlightStateEvent");
function SetFloodlightStateEvent:emptyNew()
    local self = Event:new(SetFloodlightStateEvent_mt);
    self.className="SetFloodlightStateEvent";
    return self;
end;

function SetFloodlightStateEvent:new(vehicle, state)
    local self = SetFloodlightStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function SetFloodlightStateEvent:readStream(streamId, connection)
    self.vehicle = networkGetObject(streamReadInt32(streamId));
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetFloodlightStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.state);
end;

function SetFloodlightStateEvent:run(connection)
	self.vehicle:SetFloodlightState(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetFloodlightStateEvent:new(self.vehicle, self.state), nil, connection, self.vehicle);
    end;
end;

function SetFloodlightStateEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetFloodlightStateEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetFloodlightStateEvent:new(vehicle, state));
		end;
	end;
end;