--
--	chaffCover 
--	uses an animation, defined in the .i3d of the mod
--	to lift/lower the chaffCover
--
--	author:		fruktor
--	date:		09.06.2011
--	version:	0.1	- initial implementaion
--
--	Copyright (C) - www.eifok-team.de
--      _  __      _           _                       
--     (_)/ _|    | |         | |                      
--  ___ _| |_ ___ | | ________| |_ ___  __ _ _ __ ___  
-- / _ \ |  _/ _ \| |/ /______| __/ _ \/ _` | '_ ` _ \ 
--|  __/ | || (_) |   <       | ||  __/ (_| | | | | | |
-- \___|_|_| \___/|_|\_\       \__\___|\__,_|_| |_| |_|
--

ChaffCover = {};

function ChaffCover.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function ChaffCover:load(xmlFile)

	self.updateTargetTimeCover = SpecializationUtil.callSpecializationsFunction("updateTargetTimeCover");

	self.chaffCover = {};
	self.chaffCover.index 		= Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chaffCover#index"));
	self.chaffCover.charSet 	= getAnimCharacterSet(self.chaffCover.index);
	self.chaffCover.clip 		= getXMLString(xmlFile, "vehicle.chaffCover#clip");
	self.chaffCover.clipIdx 	= getAnimClipIndex(self.chaffCover.charSet, self.chaffCover.clip);	
	self.chaffCover.speedScale 	= getXMLFloat(xmlFile, "vehicle.chaffCover#speedScale");
	self.chaffCover.duration 	= getAnimClipDuration(self.chaffCover.charSet, self.chaffCover.clipIdx);
	self.chaffCover.curTime 	= getAnimTrackTime(self.chaffCover.charSet, 0);
	self.chaffCover.targetTime 	= 0;
	self.chaffCover.maxFillLevel = getXMLInt(xmlFile, "vehicle.chaffCover#maxFillLevel"); 
	
	local x, y, z = getTranslation( self.fillAutoAimTargetNode );
	self.chaffCover.autoAimPos = {x, y, z};
	self.chaffCover.autoAimTrans = getXMLFloat(xmlFile, "vehicle.chaffCover#autoAimTrans");
	
end;

function ChaffCover:delete()
end;

function ChaffCover:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ChaffCover:keyEvent(unicode, sym, modifier, isDown)
end;

function ChaffCover:readStream(streamId, connection)
	--self.chaffCover.targetTime = streamReadFloat32(streamId);
	local curTime = streamReadFloat32(streamId);
	self.chaffCover.targetTime = curTime;
	--self:updateTargetTimeCover(curTime, true);
end;

function ChaffCover:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.chaffCover.targetTime);
end;

function ChaffCover:update(dt)
	
	local curTime = getAnimTrackTime(self.chaffCover.charSet, 0);
	local targetTime = nil;
	self.chaffCover.curTime = curTime;

	if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.CHAFFCOVER_open) then
			targetTime = Utils.getMovedLimitedValues({self.chaffCover.curTime}, {0}, {self.chaffCover.duration}, 1, self.chaffCover.duration, dt, false);
		elseif InputBinding.isPressed(InputBinding.CHAFFCOVER_close) then
			targetTime = Utils.getMovedLimitedValues({self.chaffCover.curTime}, {0}, {self.chaffCover.duration}, 1, self.chaffCover.duration, dt, true);
		end;
	end;
	
	if self.fillLevel >= self.chaffCover.maxFillLevel then
        targetTime = Utils.getMovedLimitedValues({self.chaffCover.curTime}, {0}, {self.chaffCover.duration}, 1, self.chaffCover.duration, dt, false);
    end;
    
    if targetTime ~= nil then
		self:updateTargetTimeCover(targetTime[1]);
	end;
		
	self.jointmove = false;
	if math.abs(curTime - self.chaffCover.targetTime) > 5 then
		if curTime < self.chaffCover.targetTime then
			assignAnimTrackClip(self.chaffCover.charSet, 0, self.chaffCover.clipIdx, self.chaffCover.clip); 
			setAnimTrackSpeedScale(self.chaffCover.charSet, 0, self.chaffCover.speedScale);
			enableAnimTrack(self.chaffCover.charSet, 0);	
			self.jointmove = true;
		elseif curTime > self.chaffCover.targetTime then
			assignAnimTrackClip(self.chaffCover.charSet, 0, self.chaffCover.clipIdx, self.chaffCover.clip); 
			setAnimTrackSpeedScale(self.chaffCover.charSet, 0, -self.chaffCover.speedScale);
			enableAnimTrack(self.chaffCover.charSet, 0);	
			self.jointmove = true;
		end;
		local fac = self.chaffCover.targetTime/self.chaffCover.duration;
		setTranslation( self.fillAutoAimTargetNode, 
			self.chaffCover.autoAimPos[1], self.chaffCover.autoAimPos[2], self.chaffCover.autoAimPos[3]+fac*self.chaffCover.autoAimTrans );
	else
		--assignAnimTrackClip(self.chaffCover.charSet, 0, self.chaffCover.clipIdx, self.chaffCover.clip); 
		setAnimTrackSpeedScale(self.chaffCover.charSet, 0, 0);
		disableAnimTrack(self.chaffCover.charSet, 0);	
		clearAnimTrackClip(self.chaffCover.charSet, 0);		
		self.jointmove = false;
	end;
	
end;

function ChaffCover:updateTick(dt)
end;

function ChaffCover:draw()

    if self.fillLevel <= self.chaffCover.maxFillLevel then
        g_currentMission:addExtraPrintText( string.format(g_i18n:getText("CHAFFCOVER_CLOSEOPEN"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.CHAFFCOVER_close), InputBinding.getKeyNamesOfDigitalAction(InputBinding.CHAFFCOVER_open) ) );
    end;
    		
end;

function ChaffCover:updateTargetTimeCover(targetTime, noEventSend)
	UpdateTargetTimeCoverEvent.sendEvent(self, targetTime, noEventSend);
	
	self.chaffCover.targetTime = targetTime;
	--print("self.chaffCover.targetTime="..self.chaffCover.targetTime);
end;

--
--
--
--
--
UpdateTargetTimeCoverEvent = {};
UpdateTargetTimeCoverEvent_mt = Class(UpdateTargetTimeCoverEvent, Event);

InitEventClass(UpdateTargetTimeCoverEvent, "UpdateTargetTimeCoverEvent");

function UpdateTargetTimeCoverEvent:emptyNew()
    local self = Event:new(UpdateTargetTimeCoverEvent_mt);
    self.className = "UpdateTargetTimeCoverEvent";
    return self;
end;

function UpdateTargetTimeCoverEvent:new(object, value)
    local self = UpdateTargetTimeCoverEvent:emptyNew()
    self.object = object;
	self.value = value;
    return self;
end;

function UpdateTargetTimeCoverEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.value = streamReadFloat32(streamId);
    self:run(connection);
end;

function UpdateTargetTimeCoverEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteFloat32(streamId, self.value);
end;

function UpdateTargetTimeCoverEvent:run(connection)
	self.object:updateTargetTimeCover(self.value, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(UpdateTargetTimeCoverEvent:new(self.object, self.value), nil, connection, self.object);
	end;
end;

function UpdateTargetTimeCoverEvent.sendEvent(vehicle, value, noEventSend)

	if vehicle.chaffCover.targetTime ~= value then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(UpdateTargetTimeCoverEvent:new(vehicle, value), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(UpdateTargetTimeCoverEvent:new(vehicle, value));
			end;
		end;
	end;
end;