PartesMoveis = {};

function PartesMoveis.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PartesMoveis:load(xmlFile)
	self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;
	-- Ladder movements --
	
	local rotationNodeEscada = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationEscada#index"));
    if rotationNodeEscada ~= nil then
        self.rotationEscada = {};
        self.rotationEscada.node = rotationNodeEscada;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEscada#minRot"));
        self.rotationEscada.minRot = {};
        self.rotationEscada.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEscada.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEscada.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationEscada#maxRot"));
        self.rotationEscada.maxRot = {};
        self.rotationEscada.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationEscada.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationEscada.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationEscada.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEscada#rotTime"), 2)*1000;
        self.rotationEscada.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationEscada#touchRotLimit"), 10));
    end;


	local rotationNodeTampa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationTampa#index"));
    if rotationNodeTampa ~= nil then
        self.rotationTampa = {};
        self.rotationTampa.node = rotationNodeTampa;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTampa#minRot"));
        self.rotationTampa.minRot = {};
        self.rotationTampa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTampa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTampa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationTampa#maxRot"));
        self.rotationTampa.maxRot = {};
        self.rotationTampa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationTampa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationTampa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationTampa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTampa#rotTime"), 2)*1000;
        self.rotationTampa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationTampa#touchRotLimit"), 10));
    end;
	self.Escada = false;
	self.Tampa = false;	
	
end;

function PartesMoveis:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
end;

function PartesMoveis:getSaveAttributesAndNodes(nodeIdent)
end;


function PartesMoveis:delete()
end;

function PartesMoveis:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PartesMoveis:keyEvent(unicode, sym, modifier, isDown)
		if isDown and sym == self.keys.Escada then
			self.Escada = not self.Escada;
		end;
		
		if isDown and sym == self.keys.Tampa then
			self.Tampa = not self.Tampa;
		end;
end;

function PartesMoveis:update(dt)

	-- Movements --
		-- Escada --
	local doRotate = self.rotationEscadaMax or self.rotationEscadaMin 
	if self.rotationEscada ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationEscada.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationEscada.maxRot, self.rotationEscada.minRot, 3, self.rotationEscada.rotTime, dt, not self.rotationEscadaMax);
        setRotation(self.rotationEscada.node, unpack(newRot));
    end;
		
	if self.Escada then
		self.rotationEscadaMax = true;
		self.rotationEscadaMin = false;
	else
		self.rotationEscadaMax = false;
		self.rotationEscadaMin = true;
	end;

		-- Tampa --
	local doRotate = self.rotationTampaMax or self.rotationTampaMin 
	if self.rotationTampa ~= nil and doRotate then
        local x, y, z = getRotation(self.rotationTampa.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationTampa.maxRot, self.rotationTampa.minRot, 3, self.rotationTampa.rotTime, dt, not self.rotationTampaMax);
        setRotation(self.rotationTampa.node, unpack(newRot));
    end;

		
	if self.Tampa then
		self.rotationTampaMax = true;
		self.rotationTampaMin = false;
	else
		self.rotationTampaMax = false;
		self.rotationTampaMin = true;
	end;
	

end;

function PartesMoveis:onLeave()
end;

function PartesMoveis:onEnter()
end;

function PartesMoveis:draw()

end;


function PartesMoveis:onDeactivateSounds()
 
end;

function PartesMoveis:setGrainTankFillLevel(fillLevel, fruitType)
end;
