--[[************************************************************************************************************************************************************
	
	universalToggleParts v1.3 ... Events for MP and DS
	
	02/2014 by Saty / http://forum.lsczech.cz
	
****************************************************************************************************************************************************************
	
	(EN) INFO
	
	Free for use on mods. Modifications only with my permission !
	
****************************************************************************************************************************************************************
	
	(CZ) INFO
	
	Pro volne pouziti v modech. ZAKAZ modifikaci bez meho souhlasu !
	
************************************************************************************************************************************************************]]--

toggleVisEvent = {};
toggleVisEvent_mt = Class(toggleVisEvent, Event);
InitEventClass(toggleVisEvent, "toggleVisEvent");

function toggleVisEvent:emptyNew()
	local self = Event:new(toggleVisEvent_mt);
	self.className = "toggleVisEvent";
	return self;
end;

function toggleVisEvent:new(object, name, state)
	local self = toggleVisEvent:emptyNew()
	self.object = object;
	self.name = name;
	self.state = state;
	return self;
end;

function toggleVisEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.name  = streamReadInt8(streamId);
	self.state = streamReadBool(streamId);
	self:run(connection);
end;

function toggleVisEvent:writeStream(streamId, connection)
		streamWriteInt32(streamId, networkGetObjectId(self.object));
		streamWriteInt8(streamId, self.name);
		streamWriteBool(streamId, self.state);
end;

function toggleVisEvent:run(connection)
	self.object:toggleVisibility(self.name, self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(toggleVisEvent:new(self.object, self.name, self.state), nil, connection, self.object);
	end;
end;

function toggleVisEvent.sendEvent(vehicle, name, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(toggleVisEvent:new(vehicle, name, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(toggleVisEvent:new(vehicle, name, state));
		end;
	end;
end;

togglePartEvent = {};
togglePartEvent_mt = Class(togglePartEvent, Event);
InitEventClass(togglePartEvent, "togglePartEvent");

function togglePartEvent:emptyNew()
	local self = Event:new(togglePartEvent_mt);
	self.className="togglePartEvent";
	return self;
end;

function togglePartEvent:new(object, name, state)
	local self = togglePartEvent:emptyNew()
	self.object = object;
	self.name = name;
	self.state = state;
	return self;
end;

function togglePartEvent:readStream(streamId, connection)
	self.object = networkGetObject(streamReadInt32(streamId));
	self.name  = streamReadInt8(streamId);
	self.state = streamReadBool(streamId);
	self:run(connection);
end;

function togglePartEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.name);
	streamWriteBool(streamId, self.state);
end;

function togglePartEvent:run(connection)
	self.object:togglePart(self.name, self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(togglePartEvent:new(self.object, self.name, self.state), nil, connection, self.object);
	end;
end;

function togglePartEvent.sendEvent(vehicle, name, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(togglePartEvent:new(vehicle, name, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(togglePartEvent:new(vehicle, name, state));
		end;
	end;
end;