-- by "Marhu" 
-- v 1.0
-- Date: 04.05.2013
-- "movingBelt for moving TipTrigger"
   
movingBelt = {};

movingBelt.ModDirectory = g_currentModDirectory

local movingBelt_mt = Class(movingBelt);


function movingBelt.onCreate(id)
	local Belt = movingBelt:new(g_server ~= nil, g_client ~= nil);
	g_currentMission:addUpdateable(Belt);
    Belt:load(id);
  
	--print("created movingBelt, id: ", id);
end;

function movingBelt:new(isServer, isClient)
	local self = {};
    if mt == nil then
        mt = movingBelt_mt;
	end;
	setmetatable(self, mt);
	
	return self;
end;

function movingBelt:load(id)
	
	self.triggerId = Utils.indexToObject(id, getUserAttribute(id, "triggerIndex"));
	local Belt = Utils.indexToObject(id,getUserAttribute(id, "BeltIndex"));
	if Belt ~= nil then
		self.Belt = Belt
		self.BeltSpeed = Utils.getNoNil(getUserAttribute(id, "BeltSpeed"),-0.7);
		setShaderParameter(self.Belt, "scollSpeed", 0,0,0,0,false);
	end;

	local PS = Utils.indexToObject(id,getUserAttribute(id, "PSIndex"));
	if PS ~= nil then
		self.PS = {};
		Utils.loadParticleSystemFromNode(PS, self.PS, true, true);
		for _, ps in ipairs(self.PS) do
			local lifespan = getParticleSystemLifespan(ps.geometry);
			addParticleSystemSimulationTime(ps.geometry, lifespan);
		end
		Utils.setParticleSystemTimeScale(self.PS, 0);
	end;
	local Sound = Utils.indexToObject(id,getUserAttribute(id, "SoundIndex"));
	if Sound ~= nil then
		self.Sound = Sound
		setVisibility(self.Sound, false);
	end
end;
  
function movingBelt:delete()
	if self.PS then
		Utils.deleteParticleSystem(self.PS);
	end;
end;
  
function movingBelt:readStream(streamId, connection)
	
	if connection:getIsServer() then
		
	end;
end;

function movingBelt:writeStream(streamId, connection)
	
	if not connection:getIsServer() then
		
	end;
end;

function movingBelt:readUpdateStream(streamId, timestamp, connection)
	
	if connection:getIsServer() then
        
	end;
end;
  
function movingBelt:writeUpdateStream(streamId, connection, dirtyMask)
	
	if not connection:getIsServer() then
        
    end;
end;
 
function movingBelt:update(dt)
	
	if not self.trigger then
		for k,trigger in pairs(g_currentMission.onCreateLoadedObjects) do
			if trigger.rootNode == self.triggerId then
				self.trigger = trigger
				break;
			end
		end
		if not self.trigger then
			if g_currentMission.tipTriggers ~= nil then
				for k,trigger in pairs(g_currentMission.tipTriggers) do
					if trigger.rootNode == self.triggerId then
						self.trigger = trigger
						break;
					end;
				end;
			end;
		end;
	end;
	
	local isMove = false
	if self.trigger then
		local x,y,z = getTranslation(self.trigger.movingId);
		if y > self.trigger.moveMinY then
			isMove = true
		end
	end;
	
	if isMove then
		if not self.IsBandEnable then
			self.IsBandEnable = true
			if self.Belt then setShaderParameter(self.Belt, "scollSpeed", 0,self.BeltSpeed,0,0,false); end;
			if self.PS then Utils.setParticleSystemTimeScale(self.PS, 1.0); end;
			if self.Sound then setVisibility(self.Sound, true); end;
		end;
	else
		if self.IsBandEnable then
			self.IsBandEnable = false
			if self.Belt then setShaderParameter(self.Belt, "scollSpeed", 0,0,0,0,false); end;
			if self.PS then Utils.setParticleSystemTimeScale(self.PS, 0.0); end;
			if self.Sound then setVisibility(self.Sound, false); end;
		end;
	end;
end;

function movingBelt:updateTick(dt)
end;


g_onCreateUtil.addOnCreateFunction("movingBelt", movingBelt.onCreate);
