--
-- InteractiveDoors
-- Specialization for InteractiveDoors
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v3.0
-- @date  		24/10/12
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v3.0 - converted to ls2013
--
-- free for noncommerical-usage
--

InteractiveDoors = {};

function InteractiveDoors.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function InteractiveDoors:load(xmlFile)

	local i=0;
	while true do
		local DoorName = string.format("vehicle.interactiveComponents.Doors.Door(%d)", i);	
		if not hasXMLProperty(xmlFile, DoorName) then
			break;
		end;
		local animation = getXMLString(xmlFile, DoorName .. "#animName");
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, DoorName .. "#name")), "ERROR");			
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, DoorName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, DoorName .. "#size"), 0.1);
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, DoorName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, DoorName .. "#offMessage") , "ic_button_off"));		
		local Door = Door:new(highlight, name, animation, mark, size, self, onMessage, offMessage, self.infoBar);
		Door.synch = Utils.getNoNil(getXMLBool(xmlFile, DoorName .. "#synch"), true);
		table.insert(self.interactiveObjects, Door);
		i = i + 1;
	end;
end;

function InteractiveDoors:delete()
end;

function InteractiveDoors:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveDoors:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveDoors:update(dt)	
end;

function InteractiveDoors:draw()
end;



--
-- Door Class
-- Specifies an interactive Door
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  26/12/09
--

Door = {};

function Door:new(highlight, name, animation, mark, size, vehicle, onMessage, offMessage, infobar)

	local Door_mt = Class(Door, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(nil, highlight, name, mark, size, onMessage, offMessage, infobar, Door_mt);
	instance.vehicle = vehicle;
	instance.animation = animation;

	return instance;
end;

function Door:delete()
	InteractiveComponentInterface.delete(self);
end;

function Door:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Door:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Door:update(dt)
	InteractiveComponentInterface.update(self, dt);
end;

function Door:draw()
	InteractiveComponentInterface.draw(self);
end;

function Door:doAction(noEventSend, forceAction)
	InteractiveComponentInterface.doAction(self, forceAction);
	local dir = 1;
	if not self.isOpen  then
		dir = -1;
	end;
	self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
end;

function Door:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Door:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Door:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Door:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;