--
-- T150K
-- Specialization for T150K
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - added network support, changed update to updateTick
--

T150K = {};

function T150K.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T150K:load(xmlFile)

-- fan

    self.fan = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.fan#index"));
    self.fanRotation = 0;

-- motor

    self.motor1Active = false;
    self.motor2Active = false;		
    self.delayOnLeft = 0;
    self.delayOffLeft = 0;
    self.delayOnRight = 0;
    self.delayOffRight = 0;
    self.delayKurs1 = 0;
    self.delayKurs2 = 0;
    self.delayOn = 0;
    self.delayOff = 0;
    self.deltafo = 0;

  local motor1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor1#index"));
    if motor1Node ~= nil then
        self.motor1 = {};
        self.motor1.node = motor1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#minRot"));
        self.motor1.minRot = {};
        self.motor1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor1#maxRot"));
        self.motor1.maxRot = {};
        self.motor1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#rotTime"), 2)*70;
        self.motor1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor1#touchRotLimit"), 10));
    end;

  local motor2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.motor2#index"));
    if motor2Node ~= nil then
        self.motor2 = {};
        self.motor2.node = motor2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#minRot"));
        self.motor2.minRot = {};
        self.motor2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.motor2#maxRot"));
        self.motor2.maxRot = {};
        self.motor2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.motor2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.motor2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.motor2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#rotTime"), 2)*70;
        self.motor2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.motor2#touchRotLimit"), 10));
    end;

-- kardan

        self.crankshaft1Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft1#index"));
        self.crankshaft2Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft2#index"));
        self.crankshaft3Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft3#index"));
        self.crankshaft4Node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.crankshaft4#index"));

-- naveska

	local rotationNode8 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotation8#index"));
    if rotationNode8 ~= nil then
        self.rotation8 = {};
        self.rotation8.node = rotationNode8;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#minRot"));
        self.rotation8.minRot = {};
        self.rotation8.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation8#maxRot"));
        self.rotation8.maxRot = {};
        self.rotation8.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation8.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation8.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotation8.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#rotTime"), 2)*1000;
        self.rotation8.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation8#touchRotLimit"), 10));
    end;
end;

function T150K:delete()
end;

function T150K:readStream(streamId, connection)
end;

function T150K:writeStream(streamId, connection)
end;

function T150K:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T150K:keyEvent(unicode, sym, modifier, isDown)
	if isDown and sym == Input.KEY_KP_0 then
		self.helpPanel = not self.helpPanel;
	end;
	if sym == Input.KEY_n then
		self.rotation8Max = isDown;
	end;
	if sym == Input.KEY_m then
		self.rotation8Min = isDown;
	end;
end;

function T150K:update(dt)

-- fan

if self.isMotorStarted and self.fan ~= nil then
    rotate(self.fan, 0, 0, dt*0.009);
end;

-- motor

        if self.motor1Active ~= nil and self.isMotorStarted then
			   if self.delayKurs1 >= 0 then
				self.delayKurs1 = self.delayKurs1 -dt;
			end;
			   if self.delayKurs2 >= 0 then
				self.delayKurs2 = self.delayKurs2 -dt;
			end;
			     if not self.motor1Max then
				   if self.delayKurs1 < 0 then
					self.delayKurs2 = 70;
					self.motor1Max = true;
					self.motor2Max = true;
				end;
			end;
			         if self.motor1Max then
				   if self.delayKurs2 < 0 then
					self.delayKurs1 = 70;
					self.motor1Max = false;
					self.motor2Max = false;
				end;
			end;
		else
			self.motor1Max = false;
			self.motor2Max = false;
		end;

      if self.motor1 ~= nil then
        	local x, y, z = getRotation(self.motor1.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.motor1.maxRot, self.motor1.minRot, 3, self.motor1.rotTime, dt, not self.motor1Max);
        	setRotation(self.motor1.node, unpack(newRot));
    	end;

      if self.motor2 ~= nil then
        	local x, y, z = getRotation(self.motor2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.motor2.maxRot, self.motor2.minRot, 3, self.motor2.rotTime, dt, not self.motor2Max);
        	setRotation(self.motor2.node, unpack(newRot));
    	end;

-- kardan

if self.crankshaft1Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft1Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
if self.crankshaft2Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft2Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
if self.crankshaft3Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft3Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;
if self.crankshaft4Node ~= nil and (self.movingDirection > 0 or self.movingDirection < 0) then
         	rotate(self.crankshaft4Node, 0, 0, self.motor.lastMotorRpm*0.001);
    	end;

-- naveska

	local doRotate = self.rotation8Max or self.rotation8Min 
	if self.rotation8 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation8.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation8.maxRot, self.rotation8.minRot, 3, self.rotation8.rotTime, dt, not self.rotation8Max);
        setRotation(self.rotation8.node, unpack(newRot));
    end;
end;

function T150K:updateTick(dt)
end;

function T150K:draw()
	if not self.helpPanel then
			renderText(0.76, 0.167, 0.0193, g_i18n:getText("Info_ON"));
		else
			renderText(0.76, 0.167, 0.0193, g_i18n:getText("Info_OFF"));
		end;
		if self.helpPanel then
			renderText(0.72, 0.64, 0.025, g_i18n:getText("Info_avto"));
			renderText(0.72, 0.60, 0.02, g_i18n:getText("Motor"));
			renderText(0.72, 0.58, 0.02, g_i18n:getText("Lev_povorot"));
			renderText(0.72, 0.56, 0.02, g_i18n:getText("Avarijka"));
			renderText(0.72, 0.54, 0.02, g_i18n:getText("Prav_povorot"));
			renderText(0.72, 0.52, 0.02, g_i18n:getText("Mirrors"));
			renderText(0.72, 0.50, 0.02, g_i18n:getText("LowerUp"));
			renderText(0.72, 0.48, 0.02, g_i18n:getText("LowerDown"));
	end;	
end;

function T150K:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;