--
-- Deichsel
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Deichsel = {};

function Deichsel.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Deichsel:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local deichsel = {};
    deichsel.name = getXMLString(xmlFile, "vehicle.deichsel#name");
    deichsel.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deichsel#upSpeedScale"), 1);
    deichsel.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.deichsel#downSpeedScale"), -deichsel.openSpeedScale);
    if deichsel.name ~= nil then
        self.deichsel = deichsel;
    end;
	self.deichsel.active = false;
	
	local klappe = {};
    klappe.name = getXMLString(xmlFile, "vehicle.klappe#name");
    klappe.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.klappe#upSpeedScale"), 1);
    klappe.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.klappe#downSpeedScale"), -klappe.openSpeedScale);
    if klappe.name ~= nil then
        self.klappe = klappe;
    end;
	self.klappe.active = false;
	
	
	local i=0;
    while true do
        local key = string.format("vehicle.animations.animation(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local name = getXMLString(xmlFile, key.."#name");
        if name ~= nil then		
			if name == "klappe" then			
				local partKey = key..string.format(".part(%d)", 0);
				local loadTime = getXMLFloat(xmlFile, partKey.."#loadTime");
				local endTime = getXMLFloat(xmlFile, partKey.."#endTime");
				
				local currentTime = self:getAnimationTime(self.klappe.name);
				local speed = 1;
				if currentTime > loadTime/endTime then
					speed = -1;
				end;
				self:playAnimation(self.klappe.name, speed, currentTime, true);
				self:setAnimationStopTime(self.klappe.name, loadTime/endTime);
				AnimatedVehicle.updateAnimations(self, 99999999);				
			end;
        end;
        i = i+1;
    end;
	
	self.jointmove = false;

	
end;

function Deichsel:delete()
end;

function Deichsel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Deichsel:keyEvent(unicode, sym, modifier, isDown)
end;

function Deichsel:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local deichselAnimTime = streamReadFloat32(streamId);
	local klappeAnimTime = streamReadFloat32(streamId);
	
	if deichselAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.deichsel.name);
		local speed = 1;
		if currentTime > deichselAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.deichsel.name, speed, currentTime, true);
		self:setAnimationStopTime(self.deichsel.name, deichselAnimTime);
	end;
	
	if klappeAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.klappe.name);
		local speed = 1;
		if currentTime > klappeAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.klappe.name, speed, currentTime, true);
		self:setAnimationStopTime(self.klappe.name, klappeAnimTime);	
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function Deichsel:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.deichsel.name));
	streamWriteFloat32(streamId, self:getAnimationTime(self.klappe.name));
end;

function Deichsel:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local isDeichselActive = false;
		if InputBinding.isPressed(InputBinding.DEICHSELUP1) then
			self.jointmove = true;		
			isDeichselActive = true;
			if InputBinding.hasEvent(InputBinding.DEICHSELUP1) then
				self:playAnimation(self.deichsel.name, self.deichsel.openSpeedScale, self:getAnimationTime(self.deichsel.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.DEICHSELDOWN1) then
			self.jointmove = true;	
			isDeichselActive = true;	
			if InputBinding.hasEvent(InputBinding.DEICHSELDOWN1) then
				self:playAnimation(self.deichsel.name, self.deichsel.closeSpeedScale, self:getAnimationTime(self.deichsel.name)); 
			end;			
		end;
			
		if self.deichsel.active and not isDeichselActive then
			self:stopAnimation(self.deichsel.name);	
			self.jointmove = false;
		end;
		self.deichsel.active = isDeichselActive;
		
		
		local isKlappeActive = false;
		if InputBinding.isPressed(InputBinding.KLAPPEDOWN1) then
		    self:playAnimation(self.klappe.name, self.klappe.openSpeedScale, self:getAnimationTime(self.klappe.name)); 
			isKlappeActive = true;	
			if InputBinding.hasEvent(InputBinding.KLAPPEDOWN1) then
				self:playAnimation(self.klappe.name, self.klappe.openSpeedScale, self:getAnimationTime(self.klappe.name)); 
			end;			
		elseif InputBinding.isPressed(InputBinding.KLAPPEUP1) then
			self:playAnimation(self.klappe.name, self.klappe.closeSpeedScale, self:getAnimationTime(self.klappe.name));
			isKlappeActive = true;
			if InputBinding.hasEvent(InputBinding.KLAPPEUP1) then
				self:playAnimation(self.klappe.name, self.klappe.closeSpeedScale, self:getAnimationTime(self.klappe.name));
			end;
		end
		if self.klappe.active and not isKlappeActive then
      		self:stopAnimation(self.klappe.name);	
		end;
		self.klappe.active = isKlappeActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function Deichsel:updateTick(dt)
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;
end;

function Deichsel:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.DEICHSELUP1).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DEICHSELDOWN1)..": Knickdeichsel auf / ab");
	--g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.KLAPPEDOWN1).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.KLAPPEUP1)..": Klappe auf / zu");
	

end;

function Deichsel:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


