--
-- wheelsets.lua / class: wheelSet
-- Spezialisation to switch between different Sets of Wheels
--
-- @author  Sven777b
-- @date  03.09.2010
--

wheelSet = {};

function wheelSet.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function wheelSet:load(xmlFile)
	local s=0;
	self.wheelsets = {};
	while true do
		local w=0;
		if getXMLString(xmlFile,string.format("vehicle.wheelsets.set(%d).wheel(0)#node",s)) == nil then break; end;
		local set = {};
		while true do
			local node = getXMLString(xmlFile, string.format("vehicle.wheelsets.set(%d).wheel(%d)#node",s,w));
			if node == nil then break; end;
			local index = Utils.indexToObject(self.components,node);
			setVisibility(index,false);
			table.insert(set, index);
			w=w+1;
		end;
		if table.getn(set) == table.getn(self.wheels) then
			table.insert(self.wheelsets,set);
		end;
		s=s+1;
	end;
	self.wheelsetCnt = table.getn(self.wheelsets);
	if self.wheelsetCnt > 0 then
		for i=1,table.getn(self.wheels) do
			self.wheels[i].driveNode = self.wheelsets[1][i];
			setVisibility(self.wheels[i].driveNode,true);
		end;
		self.wheelset = 1;
	end;
end;

function wheelSet:delete()
end;

function wheelSet:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheelSet:keyEvent(unicode, sym, modifier, isDown)
end;

function wheelSet:update(dt)
	if self:getIsActiveForInput() then
		if self.wheelsetCnt > 0 then
			if InputBinding.hasEvent(InputBinding.switchWheelSets1a) then
				self.wheelset = self.wheelset + 1;
				if self.wheelset > self.wheelsetCnt then
					self.wheelset = 1;
				end;
				for w=1,table.getn(self.wheels) do
					setVisibility(self.wheels[w].driveNode,false);
					self.wheels[w].driveNode = self.wheelsets[self.wheelset][w];
					setVisibility(self.wheels[w].driveNode,true);
				end;
			end;
		end;
	end;
end;

function wheelSet:draw()
	if self.wheelsetCnt > 0 and self:getIsActive() then
		local text = g_i18n:getText("switchWheelSets1a").." (Set"..self.wheelset..")";
		g_currentMission:addHelpButtonText(text, InputBinding.switchWheelSets1a);
	end;
end;
