--
-- Silageklappe1
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

silageklappe = {};

function silageklappe.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function silageklappe:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local silageklappe = {};
    silageklappe.name = getXMLString(xmlFile, "vehicle.silageklappe#name");
    silageklappe.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappe#upSpeedScale"), 1);
    silageklappe.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.silageklappe#downSpeedScale"), -silageklappe.openSpeedScale);
    if silageklappe.name ~= nil then
        self.silageklappe = silageklappe;
    end;
	self.silageklappe.active = false;
	
	
	self.jointmove = false;

	
end;

function silageklappe:delete()
end;

function silageklappe:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageklappe:keyEvent(unicode, sym, modifier, isDown)
end;

function silageklappe:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local silageklappeAnimTime = streamReadFloat32(streamId);
	
	if silageklappeAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.silageklappe.name);
		local speed = 1;
		if currentTime > silageklappeAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.silageklappe.name, speed, currentTime, true);
		self:setAnimationStopTime(self.silageklappe.name, silageklappeAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function silageklappe:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.silageklappe.name));
end;

function silageklappe:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local issilageklappeActive = false;
		if InputBinding.isPressed(InputBinding.POETTINGER_KLAPPE_OPEN) then
			self.jointmove = true;		
			issilageklappeActive = true;
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPE_OPEN) then
				self:playAnimation(self.silageklappe.name, self.silageklappe.openSpeedScale, self:getAnimationTime(self.silageklappe.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.POETTINGER_KLAPPE_CLOSE) then
			self.jointmove = true;	
			issilageklappeActive = true;	
			if InputBinding.hasEvent(InputBinding.POETTINGER_KLAPPE_CLOSE) then
				self:playAnimation(self.silageklappe.name, self.silageklappe.closeSpeedScale, self:getAnimationTime(self.silageklappe.name)); 
			end;			
		end;
			
		if self.silageklappe.active and not issilageklappeActive then
			self:stopAnimation(self.silageklappe.name);	
			self.jointmove = false;
		end;
		self.silageklappe.active = issilageklappeActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function silageklappe:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function silageklappe:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPE_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETTINGER_KLAPPE_CLOSE)..": Silage Klappe 1 auf / zu");
	
end;

function silageklappe:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


