--
-- Body Bagger Working Script
--
-- by Zippo
-- 


TIH445 = {}

function TIH445.prerequisitesPresent(specializations)
	Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function TIH445:load(xmlFile)
    
	local rotationNode1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation1#index"));
    if rotationNode1 ~= nil then
        self.rotation1 = {};
        self.rotation1.node = rotationNode1;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#minRot"));
        self.rotation1.minRot = {};
        self.rotation1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation1#maxRot"));
        self.rotation1.maxRot = {};
        self.rotation1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#rotTime"), 2)*1000;
        self.rotation1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation1#touchRotLimit"), 10));
    end;
	
	local rotationNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation2#index"));
    if rotationNode2 ~= nil then
        self.rotation2 = {};
        self.rotation2.node = rotationNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#minRot"));
        self.rotation2.minRot = {};
        self.rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation2#maxRot"));
        self.rotation2.maxRot = {};
        self.rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#rotTime"), 2)*1000;
        self.rotation2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation2#touchRotLimit"), 10));
    end;
    local rotationNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation3#index"));
    if rotationNode3 ~= nil then
        self.rotation3 = {};
        self.rotation3.node = rotationNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#minRot"));
        self.rotation3.minRot = {};
        self.rotation3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation3#maxRot"));
        self.rotation3.maxRot = {};
        self.rotation3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#rotTime"), 2)*1000;
        self.rotation3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation3#touchRotLimit"), 10));
    end;
    
    local rotationNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation4#index"));
    if rotationNode4 ~= nil then
        self.rotation4 = {};
        self.rotation4.node = rotationNode4;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#minRot"));
        self.rotation4.minRot = {};
        self.rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation4#maxRot"));
        self.rotation4.maxRot = {};
        self.rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#rotTime"), 2)*1000;
        self.rotation4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation4#touchRotLimit"), 10));
    end;
 
    local rotationNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotation5#index"));
    if rotationNode5 ~= nil then
        self.rotation5 = {};
        self.rotation5.node = rotationNode5;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#minRot"));
        self.rotation5.minRot = {};
        self.rotation5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotation5#maxRot"));
        self.rotation5.maxRot = {};
        self.rotation5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotation5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotation5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotation5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#rotTime"), 2)*1000;
        self.rotation5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotation5#touchRotLimit"), 10));
    end;
 
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	

        local hydraulic = getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic");
	if hydraulic ~= nil then
		self.hydraulic = {};
		self.hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
		self.hydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
		self.hydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
		self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic2 = {};
		self.hydraulic2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexHydraulic"));
		self.hydraulic2.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexPunch"));
		self.hydraulic2.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic2.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic2.translationPunch);
		self.hydraulic2.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			
		self.hydraulic3 = {};
		self.hydraulic3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexHydraulic"));
		self.hydraulic3.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexPunch"));
		self.hydraulic3.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic3.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic3.translationPunch);
		self.hydraulic3.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

		self.hydraulic4 = {};
		self.hydraulic4.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#indexHydraulic"));
		self.hydraulic4.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#indexPunch"));
		self.hydraulic4.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#translationPunch"));
		local ax, ay, az = getWorldTranslation(self.hydraulic4.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic4.translationPunch);
		self.hydraulic4.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

			
		self.hydraulicPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
		self.hydraulicPoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#hydraulicPoint2"));
		self.hydraulicPoint3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#hydraulicPoint3"));
		self.hydraulicPoint4 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic4#hydraulicPoint4"));
			
	end;

	hydraulicSoundFile = Utils.getFilename("sounds/hydraRot.wav", self.baseDirectory);
    self.hydraulicSoundId = createSample("hydraulicSound");
    loadSample(self.hydraulicSoundId, hydraulicSoundFile, false);
    self.hydraulicPlaying = false;
	self.hydraulicSoundAllow = false;	
end;
      
function TIH445:delete()
end;

function TIH445:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function TIH445:keyEvent(unicode, sym, modifier, isDown)
	
	if sym == Input.KEY_KP_9 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_6 then
		self.translationMin = isDown;
	end;
	
	--[[ Aufbau ]]--
    if sym == Input.KEY_KP_1 then
		self.rotation1Max = isDown;
	end;
    if sym == Input.KEY_KP_3 then
		self.rotation1Min = isDown;
	end;
	
--[[ Schaufelarm ]]--	
	if sym == Input.KEY_5 then
		self.rotation4Max = isDown;
	end;
	if sym == Input.KEY_7 then
		self.rotation4Min = isDown;
	end;	
	
--[[ Hubarm ]]--	
	if sym == Input.KEY_KP_8 then
		self.rotation3Max = isDown;
	end;
        if sym == Input.KEY_KP_5 then
		self.rotation3Min = isDown;
	end;
        if sym == Input.KEY_KP_4 then
		self.rotation2Max = isDown;
	end;
	if sym == Input.KEY_KP_7 then
		self.rotation2Min = isDown;
	end;
--[[ Schaufel ]]--	
	if sym == Input.KEY_6 then
		self.rotation5Max = isDown;
	end;
	if sym == Input.KEY_8 then
		self.rotation5Min = isDown;
	end;
	
	if isDown then
		if sym == Input.KEY_KP_1 or sym == Input.KEY_KP_2 or sym == Input.KEY_KP_3 or sym == Input.KEY_KP_4
		or sym == Input.KEY_KP_5 or sym == Input.KEY_KP_6 or sym == Input.KEY_KP_7 or sym == Input.KEY_KP_8
		or sym == Input.KEY_KP_9 or sym == Input.KEY_j or sym == Input.KEY_k or sym == Input.KEY_n or sym == Input.KEY_m or sym == Input.KEY_v or sym == Input.KEY_b then
			self.hydraulicSoundAllow = true;
		end;
	else
		self.hydraulicSoundAllow = false;
	end;
end;

function TIH445:update(dt)

	
	local doTranslate = self.translationMax or self.translationMin 
	if self.translationPart ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationPart.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax); 
		setTranslation(self.translationPart.node, unpack(newTrans)); 
	end; 
	
	local doRotate = self.rotation1Max or self.rotation1Min 
	if self.rotation1 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation1.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation1.maxRot, self.rotation1.minRot, 3, self.rotation1.rotTime, dt, not self.rotation1Max);
        setRotation(self.rotation1.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
	local doRotate = self.rotation2Max or self.rotation2Min 
	if self.rotation2 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation2.maxRot, self.rotation2.minRot, 3, self.rotation2.rotTime, dt, not self.rotation2Max);
        setRotation(self.rotation2.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation3Max or self.rotation3Min 
	if self.rotation3 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation3.maxRot, self.rotation3.minRot, 3, self.rotation3.rotTime, dt, not self.rotation3Max);
        setRotation(self.rotation3.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation4Max or self.rotation4Min 
	if self.rotation4 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation4.maxRot, self.rotation4.minRot, 3, self.rotation4.rotTime, dt, not self.rotation4Max);
        setRotation(self.rotation4.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	
    local doRotate = self.rotation5Max or self.rotation5Min 
	if self.rotation5 ~= nil and doRotate then
        local x, y, z = getRotation(self.rotation5.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotation5.maxRot, self.rotation5.minRot, 3, self.rotation5.rotTime, dt, not self.rotation5Max);
        setRotation(self.rotation5.node, unpack(newRot));
		if self.hydraulicSoundAllow and not self.hydraulicPlaying then
			playSample(self.hydraulicSoundId,0,1,0);
			self.hydraulicPlaying = true;
		end;
	elseif not self.hydraulicSoundAllow and self.hydraulicPlaying then
		stopSample(self.hydraulicSoundId);
		self.hydraulicPlaying = false;
	end;	

        if self.hydraulic ~= nil then
		local ax1, ay1, az1 = getWorldTranslation(self.hydraulic.node);
		local bx1, by1, bz1 = getWorldTranslation(self.hydraulicPoint);
		local x1, y1, z1 = worldDirectionToLocal(getParent(self.hydraulic.node), bx1-ax1, by1-ay1, bz1-az1);
		setDirection(self.hydraulic.node, 0, y1*-1, z1*-1, 0, 0, 1);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax1-bx1, ay1-by1, az1-bz1);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
		end;
	end;
	if self.hydraulic2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic2.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint2);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic2.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic2.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic2.punch, 0, 0, (distance-self.hydraulic2.punchDistance)*-1);
		end;
	end;
	if self.hydraulic3 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic3.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint3);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic3.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic3.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic3.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic3.punch, 0, 0, (distance-self.hydraulic3.punchDistance)*-1);
		end;
	end;
	if self.hydraulic4 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic4.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint4);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic4.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic4.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic4.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic4.punch, 0, 0, (distance-self.hydraulic4.punchDistance)*-1);
		end;
	end;	
end;

function TIH445:draw()
end;

function TIH445:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;
