--
-- Maupu23
-- @poc@lypse
-- 
Maupu23 = {};

function Maupu23.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Maupu23:load(xmlFile)

self.smokeParticleSystems = {};
    local entry = {};
      entry.ps = {};
      Utils.loadParticleSystem(xmlFile, entry.ps, "vehicle.smokeParticleSystem", self.components, false, nil, self.baseDirectory);
      if table.getn(entry.ps) > 0 then
          entry.isActive = false;
          table.insert(self.smokeParticleSystems, entry);
      end
      local i=0;
      while true do
          local baseName = string.format("vehicle.smokeParticleSystems.smokeParticleSystem(%d)", i);
          if not hasXMLProperty(xmlFile, baseName) then
              break;
          end;
          local entry = {};
          entry.ps = {};
          Utils.loadParticleSystem(xmlFile, entry.ps, baseName, self.components, false, nil, self.baseDirectory);
          if table.getn(entry.ps) > 0 then
              entry.isActive = false;
             entry.cuttingArea = i+1;
              table.insert(self.smokeParticleSystems, entry);
          end
          i = i+1;
      end;

 self.setAddedParts = SpecializationUtil.callSpecializationsFunction("setAddedParts");
	self.cardans = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cardans#index"));
	--added parts
    self.betPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.betPart#index"));
    self.defaultPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.defaultPart#index"));
    self.ensiPart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ensiPart#index"));
    self.ensiPortepart = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ensiportePart#index"));
	
	setVisibility(self.defaultPart,true);
	setVisibility(self.ensiPart,false);
	setVisibility(self.betPart,false);
        setVisibility(self.ensiPortepart,false);	
	
	self.currentPart = 0;  
    	
end;

function Maupu23:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local currentPart = Utils.getNoNil(getXMLInt(xmlFile, key.."#currentPartVisible"), 1);		
		self:setAddedParts(currentPart, true);
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function Maupu23:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'currentPartVisible="'.. tostring(self.currentPart) .. '"';
    return attributes, nil;
end;


function Maupu23:delete()
for _, entry in ipairs(self.smokeParticleSystems) do
          Utils.deleteParticleSystem(entry.ps);
          entry.isActive = false;
end;
   
end;


function Maupu23:mouseEvent(posX, posY, isDown, isUp, button)
   
end;

function Maupu23:keyEvent(unicode, sym, modifier, isDown)
 
end;

function Maupu23:readStream(streamId, connection)
    local currentPart = streamReadInt16(streamId);
    self:setAddedParts(currentPart, false);
end;

function Maupu23:writeStream(streamId, connection)
	streamWriteInt16(streamId, self.currentPart);
end;

function Maupu23:update(dt)

         if self:getIsActive() then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.fillLevel <= 0 then
					if self.currentPart > 1 then
						self.currentPart = 0;
					else
						self.currentPart = self.currentPart +1;
					end;
					self:setAddedParts(self.currentPart);
				end;
			end;
		end;
	end;

end;

function Maupu23:updateTick(dt)
	if self.fillLevel > 0 then
		if self.currentFillType == Fillable.FILLTYPE_CHAFF then
			self:setAddedParts(2);			
		end;
                if self.currentFillType == Fillable.FILLTYPE_WHEAT or self.currentFillType == Fillable.FILLTYPE_BARLEY or self.currentFillType == Fillable.FILLTYPE_RAPE or self.currentFillType == Fillable.FILLTYPE_MAIZE then
			self:setAddedParts(0);			
		end;              
	end;

 if self.isClient then
               for _,ps in pairs(self.smokeParticleSystems) do                  
                  if self.currentFillType == Fillable.FILLTYPE_MANURE and self.fillLevel > 3000 and self.movingDirection == 0 then                       
                      Utils.setEmittingState(ps.ps, true);
                  else
                      Utils.setEmittingState(ps.ps, false);
                  end
               end
 end;

end;

function Maupu23:draw()
        if self.fillLevel <= 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("MANAGE_EXTRAPARTS"), InputBinding.LOWER_IMPLEMENT);
	end;
end;


function Maupu23:setAddedParts(currentPart, noEventSend)
	AddedPartEvent.sendEvent(self, currentPart, noEventSend);	
	if currentPart == 0 then
                setVisibility(self.defaultPart,true);
		setVisibility(self.ensiPart,false);
	        setVisibility(self.betPart,false);
                setVisibility(self.ensiPortepart,false);		
	elseif currentPart == 1 then
                setVisibility(self.defaultPart,false);
		setVisibility(self.ensiPart,false);
	        setVisibility(self.betPart,true);
                setVisibility(self.ensiPortepart,false);	
	elseif currentPart == 2 then
		setVisibility(self.defaultPart,true);
		setVisibility(self.ensiPart,true);
	        setVisibility(self.betPart,false);
                setVisibility(self.ensiPortepart,true);	
	end;
end;

function Maupu23:onAttach(attacherVehicle)
	setVisibility(self.cardans,false);	
end;

function Maupu23:onDetach()
	setVisibility(self.cardans,true);
end;

