Bordwand = {};

function Bordwand.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Bordwand:load(xmlFile)
	self.setIsBoardwallVisible = SpecializationUtil.callSpecializationsFunction("setIsBoardwallVisible");
	self.boardWall = {};
	self.boardWall.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Bordwand#index"));
	self.boardWall.addCapacity = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Bordwand#addCapacity"), 1500);
	self.boardWall.isVisible = false;
	local fillType = Fillable.fillTypeIntToName[Fillable.FILLTYPE_WHEAT];
	local curve = self.fillPlanes[fillType].nodes[1].animCurve;
	self.boardWall.maxY = curve.keyframes[table.getn(curve.keyframes)].sy;
	self.boardWall.minY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Bordwand#minY"), 0);
	self.capacity = self.capacity + self.boardWall.addCapacity;
	self.capacityBackup = self.capacity;
	self.printWarningTime = 0;
end;

function Bordwand:delete()
end;

function Bordwand:readStream(streamId, connection)
	self:setIsBoardwallVisible(streamReadBool(streamId), true);
end;

function Bordwand:writeStream(streamId, connection)
	streamWriteBool(streamId, self.boardWall.isVisible);
end;

function Bordwand:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Bordwand:keyEvent(unicode, sym, modifier, isDown)
end;

function Bordwand:update(dt)
	if self:getIsActiveForInput() then
		if self.fillLevel < 0.01 then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setIsBoardwallVisible(not self.boardWall.isVisible);
			end;
		elseif self.fillLevel > 0.01 then
			if InputBinding.isPressed(InputBinding.IMPLEMENT_EXTRA2) then
				self.printWarningTime = self.time + 1500;
			end;
		end;		
	end;		
end;

function Bordwand:updateTick(dt)
end;

function Bordwand:draw()
	if self.fillLevel < 0.01 then
		if self.boardWall.isVisible then
			g_currentMission:addHelpButtonText(g_i18n:getText("Bordwand1"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Bordwand2"), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;
	if self.printWarningTime > self.time then
		g_currentMission:addWarning(g_i18n:getText("Bordwand3"), 0.018, 0.033);
	end;
end;

function Bordwand:setIsBoardwallVisible(isVisible, noEventSend)
	BoardwallEvent.sendEvent(self, isVisible, noEventSend);	
	self.boardWall.isVisible = isVisible;
	setVisibility(self.boardWall.node, isVisible);
	local newY = self.boardWall.minY;
	if isVisible then
		self.capacity = self.capacityBackup;
		newY = self.boardWall.maxY;
	else
		self.capacity = self.capacityBackup - self.boardWall.addCapacity;
	end;
	for _, fillplane in pairs(self.fillPlanes) do
		for _, node in pairs(fillplane.nodes) do
			node.animCurve.keyframes[table.getn(node.animCurve.keyframes)].sy = newY;
		end;
	end;
	if self.fillLevel > 0 then
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
end;

function Bordwand:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isVisible = Utils.getNoNil(getXMLBool(xmlFile, key.."#isBoardwallVisible"), true);		
		self:setIsBoardwallVisible(isVisible, true);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Bordwand:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isBoardwallVisible="'.. tostring(self.boardWall.isVisible) .. '"';
    return attributes, nil;
end;

BoardwallEvent = {};
BoardwallEvent_mt = Class(BoardwallEvent, Event);
InitEventClass(BoardwallEvent, "BoardwallEvent");

function BoardwallEvent:emptyNew()
	local self = Event:new(BoardwallEvent_mt);
	self.className="BoardwallEvent";
	return self;
end;

function BoardwallEvent:new(vehicle, isVisible)
	local self = BoardwallEvent:emptyNew()
	self.vehicle = vehicle;
	self.isVisible = isVisible;
	return self;
end;

function BoardwallEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.isVisible = streamReadBool(streamId);
	self.vehicle = networkGetObject(id);
	self:run(connection);
end;

function BoardwallEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.isVisible);
end;

function BoardwallEvent:run(connection)
	self.vehicle:setIsBoardwallVisible(self.isVisible, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(BoardwallEvent:new(self.vehicle, self.isVisible), nil, connection, self.vehicle);
	end;
end;

function BoardwallEvent.sendEvent(vehicle, isVisible, noEventSend)
	if vehicle.boardWall.isVisible ~= isVisible then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(BoardwallEvent:new(vehicle, isVisible), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(BoardwallEvent:new(vehicle, isVisible));
			end;
		end;
	end;
end;
