--
-- Kaweco
-- 
--
-- @author  Mantikor
-- @date  10/01/2010
--
-- Copyright (C) Mantikor, Confidential, All Rights Reserved.

SupportFeed = {};

function SupportFeed.prerequisitesPresent(specializations)
    return true;
end;

function SupportFeed:load(xmlFile)
	self.kippen = 0;
	self.upperFeed = false;
	self.lowerFeed = false;
	
	self.entry = {};
	local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.animParts.part1#rootNode"));
	self.entry.animCharSet = 0;
	if rootNode ~= nil then
		self.entry.animCharSet = getAnimCharacterSet(rootNode);
		if self.entry.animCharSet ~= 0 then
			local clip = getAnimClipIndex(self.entry.animCharSet, getXMLString(xmlFile, "vehicle.animParts.part1#animationClip"));
			if clip >= 0 then
				assignAnimTrackClip(self.entry.animCharSet, 0, clip);
				setAnimTrackLoopState(self.entry.animCharSet, 0, false);
				self.entry.animDuration = getAnimClipDuration(self.entry.animCharSet, clip);
			end;
		end;
	end;

end;

function SupportFeed:delete()
end;

function SupportFeed:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SupportFeed:keyEvent(unicode, sym, modifier, isDown)
end;

function SupportFeed:draw()
end;

function SupportFeed:update(dt)
if self.lowerFeed then
	self.kippen = self.kippen + 10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
        if self.kippen >= 1000 then 
		self.lowerFeed = not self.lowerFeed;
	end;	
end;

if self.upperFeed then
	self.kippen = self.kippen - 10;
        enableAnimTrack(self.entry.animCharSet, 0);
        setAnimTrackTime(self.entry.animCharSet, 0, self.kippen, true);
        disableAnimTrack(self.entry.animCharSet, 0);
        if self.kippen <= 0 then 
		self.upperFeed = not self.upperFeed;
	end;
end;
end;

function SupportFeed:onAttach(attacherVehicle)
	self.upperFeed = true;
end;
 
function SupportFeed:onDetach()
       self.lowerFeed = true;
end;