--
-- GPsounds
-- Specialization for GPsounds
--
-- @author upsidedown
-- @date  04.08.2013


GPsounds = {};

function GPsounds.prerequisitesPresent(specializations)
    return true;
end;

function GPsounds:load(xmlFile)		
		if self.isClient then
			local pumpSound = Utils.getFilename("zvuky/garantPump_big.wav", self.baseDirectory);
			--local pumpSound = "$data/vehicles/trailers/garantPump_big.wav";
			self.pumpSound = createSample("pumpSound");
			loadSample(self.pumpSound, pumpSound, false);
			self.pumpSoundVolume = 0.75;
			setSamplePitch(self.pumpSound, 1);		
			self.pumpSoundEnabled = false;
			
			-- local hydraulikSoundA = Utils.getFilename("zvuky/Hydraulik1.wav", self.baseDirectory);
			
			-- self.hydraulikSoundA = createSample("hydraulikSoundA");
			-- loadSample(self.hydraulikSoundA, hydraulikSoundA, false);
			-- self.hydraulikSoundAVolume = 0.75;
			-- setSamplePitch(self.hydraulikSoundA, 1);		
			-- self.hydraulikSoundAEnabled = false;
			
			-- local hydraulikSoundB = Utils.getFilename("zvuky/Hydraulik.wav", self.baseDirectory);
			
			-- self.hydraulikSoundB = createSample("hydraulikSoundB");
			-- loadSample(self.hydraulikSoundB, hydraulikSoundB, false);
			-- self.hydraulikSoundBVolume = 0.75;
			-- setSamplePitch(self.hydraulikSoundB, 1);		
			-- self.hydraulikSoundBEnabled = false;
			
		end;
end;

function GPsounds:update(dt)	

end;

function GPsounds:updateTick(dt)	

		
		if self.isClient then
			local volume = 0;
			if self:getIsActiveForInput(false) then
				volume = 1;
			elseif g_currentMission.controlledVehicle == nil then --player on foot
				if g_currentMission.player ~= nil then
					local pvx, pvy, pvz = getWorldTranslation(g_currentMission.player.rootNode);
					local x, y, z = getWorldTranslation(self.rootNode);
					local farmerDistance = Utils.vector3Length(pvx-x, pvy-y, pvz-z);
					
					volume = (20-farmerDistance)/20
					
				end;
			end;
			
			setSampleVolume(self.pumpSound,volume*self.pumpSoundVolume)
			
			if self.hoseConnectorHUDselect == 4 and self.hoseConnectorHUDTimeOut > 0 and volume > 0 then
				if not self.pumpSoundEnabled  then
					playSample(self.pumpSound, 0, volume*self.pumpSoundVolume, 0);
					self.pumpSoundEnabled = true;
				end
			else
				if self.pumpSoundEnabled then
					self.pumpSoundEnabled = false;
					stopSample(self.pumpSound);
				end
			end;
			
			
			------------------------
			------decision part for hydraulics:
			
			
			-- local hySmall = false;
			-- local hyBig = false;
			
			-- if self.foldAnimTime < 0.999 and self.foldAnimTime > 0.6 then
				-- hySmall = true;
			-- end;
			-- if self.foldAnimTime < 0.61 and self.foldAnimTime > 0.001 then
				-- hyBig = true;
			-- end;
			
			-- if self.animParts[1].move then
				-- hySmall = true;
			-- end;
			
			
			-----------------
			---- exec hydraulic sounds:
			
			-- if hyBig then
                -- if not self.hydraulikSoundBEnabled  and self:getIsActiveForSound() then
                    -- playSample(self.hydraulikSoundB, 0, self.hydraulikSoundBVolume, 0);
                    -- self.hydraulikSoundBEnabled = true;
                -- end
            -- else
                -- if self.hydraulikSoundBEnabled then
                    -- self.hydraulikSoundBEnabled = false;
                    -- stopSample(self.hydraulikSoundB);
                -- end
            -- end;
			
			-- if hySmall then
                -- if not self.hydraulikSoundAEnabled  and self:getIsActiveForSound() then
                    -- playSample(self.hydraulikSoundA, 0, self.hydraulikSoundAVolume, 0);
                    -- self.hydraulikSoundAEnabled = true;
                -- end
            -- else
                -- if self.hydraulikSoundAEnabled then
                    -- self.hydraulikSoundAEnabled = false;
                    -- stopSample(self.hydraulikSoundA);
                -- end
            -- end;
			
			
			
		end;
end;


function GPsounds:delete()
	delete(self.pumpSound)
	self.pumpSound = nil;
	-- delete(self.hydraulikSoundA)
	-- self.hydraulikSoundA = nil;
	-- delete(self.hydraulikSoundBEnabled)
	-- self.hydraulikSoundBEnabled = nil;
end;

function GPsounds:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GPsounds:keyEvent(unicode, sym, modifier, isDown)
end;

function GPsounds:draw()	
end;

function GPsounds:onAttach()
end; 	

function GPsounds:onDetach()
end;