 

dt75 = {};

function dt75.prerequisitesPresent(specializations)
    Vehicle.registerJointType("tractor");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function dt75:load(xmlFile)
self.help = false;
local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
	local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;
	local rotationPartNodekozyrek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kozyrek#index"));
    if rotationPartNodekozyrek ~= nil then
        self.rotationPartkozyrek = {};
        self.rotationPartkozyrek.node = rotationPartNodekozyrek;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#minRot"));
        self.rotationPartkozyrek.minRot = {};
        self.rotationPartkozyrek.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kozyrek#maxRot"));
        self.rotationPartkozyrek.maxRot = {};
        self.rotationPartkozyrek.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartkozyrek.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartkozyrek.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartkozyrek.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#rotTime"), 2)*1000;
        self.rotationPartkozyrek.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.kozyrek#touchRotLimit"), 10));
    end;
	local rotationPartNodeTahometr = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTahometr#index"));
    if rotationPartNodeTahometr ~= nil then
        self.rotationPartTahometr = {};
        self.rotationPartTahometr.node = rotationPartNodeTahometr;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#minRot"));
        self.rotationPartTahometr.minRot = {};
        self.rotationPartTahometr.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTahometr#maxRot"));
        self.rotationPartTahometr.maxRot = {};
        self.rotationPartTahometr.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTahometr.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTahometr.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTahometr.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#rotTime"), 2)*1000;
        self.rotationPartTahometr.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTahometr#touchRotLimit"), 10));
    end;
	local rotationPartNodeTanknadel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotationPartTanknadel#index"));
    if rotationPartNodeTanknadel ~= nil then
        self.rotationPartTanknadel = {};
        self.rotationPartTanknadel.node = rotationPartNodeTanknadel;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#minRot"));
        self.rotationPartTanknadel.minRot = {};
        self.rotationPartTanknadel.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#maxRot"));
        self.rotationPartTanknadel.maxRot = {};
        self.rotationPartTanknadel.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartTanknadel.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartTanknadel.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartTanknadel.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#rotTime"), 2)*1000;
        self.rotationPartTanknadel.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartTanknadel#touchRotLimit"), 10));
    end;
	
end;

function dt75:delete()
   
end;


function dt75:mouseEvent(posX, posY, isDown, isUp, button)

end;

function dt75:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_0 then
	self.help = not self.help;
    end;
    if isDown and sym == Input.KEY_KP_9 then 
	self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	self.rotationMaxrightdoor1 = not self.rotationMaxrightdoor1;
    end;
	if isDown and sym == Input.KEY_KP_7 then 
	self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	self.rotationMaxleftDoor1 = not self.rotationMaxleftDoor1;
    end;
	if isDown and sym == Input.KEY_KP_8 then 
	self.rotationMaxkozyrek = not self.rotationMaxkozyrek;
    end;
	local maxDrehzahl = 1300;
	if self.rotationPartTahometr ~= nil then
		local x, y, z = getRotation(self.rotationPartTahometr.node);
		y = ((self.rotationPartTahometr.maxRot[2] - self.rotationPartTahometr.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartTahometr.minRot[2];
		setRotation(self.rotationPartTahometr.node, x, y ,z);
	end;
	
end;


function dt75:update(dt)

        if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
		if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;
		if self.rotationPartkozyrek ~= nil then
		   local x, y, z = getRotation(self.rotationPartkozyrek.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartkozyrek.maxRot, self.rotationPartkozyrek.minRot, 3, self.rotationPartkozyrek.rotTime, dt, not self.rotationMaxkozyrek);
		   setRotation(self.rotationPartkozyrek.node, unpack(newRot));
        end;
		local maxDrehzahl = 1300;
	if self.rotationPartTahometr ~= nil then
		local x, y, z = getRotation(self.rotationPartTahometr.node);
		y = ((self.rotationPartTahometr.maxRot[2] - self.rotationPartTahometr.minRot[2]) / maxDrehzahl) * self.motor.lastMotorRpm + self.rotationPartTahometr.minRot[2];
		setRotation(self.rotationPartTahometr.node, x, y ,z);
	end;
	if self.rotationPartTanknadel ~= nil then
		local x, y, z = getRotation(self.rotationPartTanknadel.node);
		y = ((self.rotationPartTanknadel.maxRot[2] - self.rotationPartTanknadel.minRot[2]) / self.fuelCapacity) * self.fuelFillLevel + self.rotationPartTanknadel.minRot[2];
		setRotation(self.rotationPartTanknadel.node, x, y ,z);
	end;
end;

function dt75:draw()

	if not self.help then
	setTextBold(true);
	setTextColor(1,1,1,1);
            renderText(0.76, 0.167, 0.0193, "Numpad 0: Info");
        else
		  renderText();
        end;
        
        if self.help then
		    renderText(0.76, 0.50, 0.02, "0: signal");
            renderText(0.76, 0.48, 0.02, "F: svet");
			renderText(0.76, 0.46, 0.02, "Numpad 6: zadniy svet");
			renderText(0.76, 0.44, 0.02, "Numpad 7: dver lev");
			renderText(0.76, 0.42, 0.02, "Numpad 8: kozirek");
			renderText(0.76, 0.40, 0.02, "Numpad 9: dver prav");
		end;

end;

function dt75:onEnter()

end;

function dt75:onLeave()

end;

function dt75:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;