--@Author: Sven777b
--@Web: www.ls-landtechnik.com

rindermastPlaceable = {};
rindermastPlaceable_mt = Class(rindermastPlaceable, Placeable);
InitObjectClass(rindermastPlaceable, "rindermastPlaceable");

function rindermastPlaceable:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, rindermastPlaceable_mt);
    registerObjectClassName(self, "rindermastPlaceable");
    return self;
end;

function rindermastPlaceable:delete()
    unregisterObjectClassName(self);
    rindermastPlaceable:superClass().delete(self);
end;

function rindermastPlaceable:deleteFinal()
    rindermastPlaceable:superClass().deleteFinal(self);
end;

function rindermastPlaceable:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not rindermastPlaceable:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
    if not moveMode then
		self.searchOnCreateObjects = rindermastPlaceable.searchOnCreateObjects;
		g_currentMission.isLoadingMap = true;
			self:searchOnCreateObjects(self.nodeId);
		g_currentMission.isLoadingMap = false;
	end;
    delete(xmlFile);
    return true;
end;

function rindermastPlaceable:searchOnCreateObjects(node)
    for i=1,getNumOfChildren(node) do
        local c = getChildAt(node, i-1);
        if getUserAttribute(c,"onCreate")~= nil  then
			local stringname = string.sub(getUserAttribute(c,"onCreate"),13);
			if g_onCreateUtil.onCreateFunctions[stringname] ~= nil then
				g_onCreateUtil.onCreateFunctions[stringname](c);			
			end;
			if getNumOfChildren(c) >0 then
				self:searchOnCreateObjects(c);
			end;
        else
            self:searchOnCreateObjects(c);
        end;
    end;
end;

registerPlaceableType("rindermastPlaceable", rindermastPlaceable);