SFMP400Event = {};
SFMP400Event_mt = Class(SFMP400Event, Event);

InitEventClass(SFMP400Event, "SFMP400Event");

function SFMP400Event:emptyNew()
    local self = Event:new(SFMP400Event_mt);
    self.className="SFMP400Event";
    return self;
end;

function SFMP400Event:new(vehicle, state)
    local self = SFMP400Event:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
    return self;
end;

function SFMP400Event:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SFMP400Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.state);
end;

function SFMP400Event:run(connection)   
	self.vehicle:foldForks(self.state, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SFMP400Event:new(self.vehicle, self.state), nil, connection, self.vehicle);
    end;
end;

function SFMP400Event.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SFMP400Event:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SFMP400Event:new(vehicle, state));
		end;
	end;
end;