﻿--
-- Strimech Foldable Fork
--
-- author Mythos
-- date  16/10/2011
-- www.ARM-Team.gr
-- Copyright (C) ARM Team, All Rights Reserved.

SFMP400 = {};
--________________________________________________________________________________________________________________________________________________________
function SFMP400.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:load(xmlFile)

	-- Functions
	self.foldForks = SpecializationUtil.callSpecializationsFunction("foldForks");
	
	-- Animations
	self.foldingForks = getXMLString(xmlFile, "vehicle.foldingForks#animationName");
	
	-- Booleans
	self.state = true;

end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:delete()
end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:mouseEvent(posX, posY, isDown, isUp, button)

end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:keyEvent(unicode, sym, modifier, isDown)

end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:update(dt)

if self:getIsActiveForInput() then
	
	
	if self.fillLevel==0 then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:foldForks(self.state);
		end;
	end;

	for i, v in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
end;

end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:updateTick(dt)

	for name,v in pairs(self.animations) do
		if name == "foldingForks" then
			if self.activeAnimations[name] ~= nil and not self.state then
				self.capacity = 0;
			elseif self.activeAnimations[name] == nil and self.state then
				self.capacity = 5500;
			end;
			break;
		end;
	end;
	
end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:draw()
	if self.fillLevel==0 then
		if self.state then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FORKS_CLOSED"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("FORKS_OPEN"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
		end;
	end;
end;

--________________________________________________________________________________________________________________________________________________________
function SFMP400:foldForks(state,noEventSend)
	SFMP400Event.sendEvent(self, state, noEventSend);
	if state then
		self:playAnimation(self.foldingForks, 1, nil, true);
		self.state = false;
	else
		self:playAnimation(self.foldingForks, -1, nil, true);
		self.state = true;
	end;
end;
