--
-- AnimatedHydraulic
--
--
-- @author  Manuel Leithner
-- @date  14/04/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

AnimatedHydraulic = {};

function AnimatedHydraulic.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function AnimatedHydraulic:load(xmlFile)
	
	self.animatedHydraulics = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.animatedHydraulics.hydraulic(%d)", i);
		if not hasXMLProperty(xmlFile, baseName) then
			break;
		end;
		local hydraulic = {};
		local index = getXMLString(xmlFile, baseName.."#refJoint");
		local refJoint = Utils.indexToObject(self.components, index);
		
		for _, joint in pairs(self.attacherJoints) do
			if joint.jointTransform == refJoint then
				hydraulic.refJoint = joint;
				break;
			end;
		end;		
		if hydraulic.refJoint == nil then
			print("AnimatedHydraulic-Error: refJoint '".. index .."' not found");
			break;
		end;
		hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#node"));
		hydraulic.movingParts = {};
		local j=0;
		while true do
			local moveBaseName = string.format(baseName.. ".movingPart(%d)", j);
			if not hasXMLProperty(xmlFile, moveBaseName) then
				break;
			end;	
			local index = getXMLString(xmlFile, moveBaseName.."#node")
			local node = Utils.indexToObject(self.components, index);
			local found = false;
			for _, movingPart in pairs(self.movingParts) do
				if movingPart.node == node then
					found = true;
					table.insert(hydraulic.movingParts, movingPart);
					break;
				end;
			end;
			
			if not found then
				print("AnimatedHydraulic-Error: movingPart '".. index .."' not found");
			end;
			j = j + 1;
		end;			
		table.insert(self.animatedHydraulics, hydraulic);
		i = i + 1;		
	end;
	
	self.doUpdatesNTimes = 0;
end;

function AnimatedHydraulic:delete()
end;

function AnimatedHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatedHydraulic:update(dt)
	if self:getIsActive() or self.doUpdatesNTimes > 0 then
		for _,hydraulic in pairs(self.animatedHydraulics) do
			
			if hydraulic.node ~= nil then
				local x,y,z = getRotation(hydraulic.refJoint.bottomArm.rotationNode);
				setRotation(hydraulic.node, x,y,z);
			end;
			-- implement is attached if joint index ~= 0
			if hydraulic.refJoint.jointIndex ~= 0 or self.doUpdatesNTimes > 0 then
				for _, part in pairs(hydraulic.movingParts) do
					Cylindered.updateMovingPart(self, part);
				end;
			end;
		end;
		
		if self.doUpdatesNTimes > 0 then
			self.doUpdatesNTimes = self.doUpdatesNTimes - 1;
		end;
	end;
end;

function AnimatedHydraulic:updateTick(dt)
end;

function AnimatedHydraulic:draw()
end;

function AnimatedHydraulic:detachImplement(implementIndex)
	self.doUpdatesNTimes = 5;
end;

