--
-- BJR_DriveGroundParticles
-- Specialization for BJR_DriveGroundParticles mod
--
-- @author  	GIANTS, JoXXer
-- @date  		11/03/13
--

BJR_DriveGroundParticles = {};

function BJR_DriveGroundParticles.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function BJR_DriveGroundParticles:load(xmlFile)
	self.BJR_DriveGroundParticleSystems = {};
	if self.isClient then
		local i=0;
		while true do
			local key = string.format("vehicle.BJR_DriveGroundParticleSystems.driveGroundParticleSystem(%d)", i);
			if not hasXMLProperty(xmlFile, key) then
				break;
			end;
			local ps = {};
			ps.particleSystems = {};
			Utils.loadParticleSystem(xmlFile, ps.particleSystems, key, self.components, false, nil, self.baseDirectory);
			if table.getn(ps.particleSystems) > 0 then
				ps.minSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minSpeed"), 2)/3600;
				ps.maxSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxSpeed"), 40)/3600;
				ps.minScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#minScale"), 0.2);
				ps.maxScale = Utils.getNoNil(getXMLFloat(xmlFile, key.."#maxScale"), 1);
				ps.direction = Utils.getNoNil(getXMLFloat(xmlFile, key.."#direction"), 1);
				ps.onlyActiveOnGroundContact = Utils.getNoNil(getXMLBool(xmlFile, key.."#onlyActiveOnGroundContact"), true);
				table.insert(self.BJR_DriveGroundParticleSystems, ps);
			end;
	
			i = i+1;
		end;
	end;
end;

function BJR_DriveGroundParticles:delete()
	for _, ps in pairs(self.BJR_DriveGroundParticleSystems) do
		Utils.deleteParticleSystem(ps.particleSystems);
	end;
end;

function BJR_DriveGroundParticles:readStream(streamId, connection)
end;

function BJR_DriveGroundParticles:writeStream(streamId, connection)
end;

function BJR_DriveGroundParticles:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BJR_DriveGroundParticles:keyEvent(unicode, sym, modifier, isDown)
end;

function BJR_DriveGroundParticles:update(dt)

end;

function BJR_DriveGroundParticles:updateTick(dt)
	if self.isActive then
		if self.isClient then
			local dens = 0; 
			local dens1; 
			local dens2; 
			local dens3;
			
			local x,y,z = getWorldTranslation(self.wheels[2].repr);
			local x1,y1,z1 = getWorldTranslation(self.wheels[1].repr);
			local x2,y2,z2 = getWorldTranslation(self.wheels[4].repr);
			local id = g_currentMission.terrainDetailId;
			local xx, zz, widthX, widthZ, heightX, heightZ = Utils.getXZWidthAndHeight(id, x, z, x1, z1, x2, z2);
			dens1 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.cultivatorChannel, 1);
			dens2 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.sowingChannel, 1);
			dens3 = getDensityParallelogram(id, xx, zz, widthX, widthZ, heightX, heightZ, g_currentMission.ploughChannel, 1);
			if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 10 then
				dens = dens1+dens2+dens3;
			end;
			for _, ps in pairs(self.BJR_DriveGroundParticleSystems) do
				if self.movingDirection ~= 0 then
					ps.direction = self.movingDirection;
				end;
				local scale = self:getDriveGroundParticleSystemsScale(ps);
				if scale > 0 and dens > 0 then
					Utils.setEmittingState(ps.particleSystems, true);
					Utils.setEmitCountScale(ps.particleSystems, scale);
				else
					Utils.setEmittingState(ps.particleSystems, false);
				end;
			end;
		end;
	else
		if self.isClient then
			for _, ps in pairs(self.BJR_DriveGroundParticleSystems) do
				Utils.setEmittingState(ps.particleSystems, false);
			end;
		end;
	end;
end;

function BJR_DriveGroundParticles:draw()

end;