--
-- internalclod
-- Specialization Real internal sound
--

internalclod = {};

function internalclod.prerequisitesPresent(specializations)
   print("Real internal sound loaded");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
	
end;

function internalclod:load(xmlFile)
	self.intCameraIndex = 2;

	local motorStartSoundInternal = getXMLString(xmlFile, "vehicle.motorStartSoundInternal#file");
	if motorStartSoundInternal ~= nil and motorStartSoundInternal ~= "" then
        motorStartSoundInternal = Utils.getFilename(motorStartSoundInternal, self.baseDirectory);
        self.motorStartSoundInternal = createSample("motorStartSoundInternal");
        loadSample(self.motorStartSoundInternal, motorStartSoundInternal, false);
        self.motorStartSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#pitchOffset"), 0);
        self.motorStartSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#volume"), 1.0);
    end;

    local motorStopSoundInternal = getXMLString(xmlFile, "vehicle.motorStopSoundInternal#file");
    if motorStopSoundInternal ~= nil and motorStopSoundInternal ~= "" then
        motorStopSoundInternal = Utils.getFilename(motorStopSoundInternal, self.baseDirectory);
        self.motorStopSoundInternal = createSample("motorStopSoundInternal");
        loadSample(self.motorStopSoundInternal, motorStopSoundInternal, false);
        self.motorStopSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#pitchOffset"), 0);
        self.motorStopSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if motorSoundInternal ~= nil and motorSoundInternal ~= "" then
        motorSoundInternal = Utils.getFilename(motorSoundInternal, self.baseDirectory);
        self.motorSoundInternal = createSample("motorSoundInternal");
        loadSample(self.motorSoundInternal, motorSoundInternal, false);
        self.motorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.motorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.motorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.motorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if motorSoundInternalRun ~= nil and motorSoundInternalRun ~= "" then
        motorSoundInternalRun = Utils.getFilename(motorSoundInternalRun, self.baseDirectory);
        self.motorSoundInternalRun = createSample("motorSoundInternalRun");
        loadSample(self.motorSoundInternalRun, motorSoundInternalRun, false);
        self.motorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.motorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.motorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.motorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;
	
    local powershiftMotorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if powershiftMotorSoundInternal ~= nil and powershiftMotorSoundInternal ~= "" then
        powershiftMotorSoundInternal = Utils.getFilename(powershiftMotorSoundInternal, self.baseDirectory);
        self.powershiftMotorSoundInternal = createSample("powershiftMotorSoundInternal");
        loadSample(self.powershiftMotorSoundInternal, powershiftMotorSoundInternal, false);
        self.powershiftMotorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.powershiftMotorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.powershiftMotorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.powershiftMotorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local powershiftMotorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if powershiftMotorSoundInternalRun ~= nil and powershiftMotorSoundInternalRun ~= "" then
        powershiftMotorSoundInternalRun = Utils.getFilename(powershiftMotorSoundInternalRun, self.baseDirectory);
        self.powershiftMotorSoundInternalRun = createSample("powershiftMotorSoundInternalRun");
        loadSample(self.powershiftMotorSoundInternalRun, powershiftMotorSoundInternalRun, false);
        self.powershiftMotorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.powershiftMotorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.powershiftMotorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.powershiftMotorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;

	self.originalMotorStartSound = self.motorStartSound;
	self.originalMotorStopSound = self.motorStopSound;
	self.originalMotorSound = self.motorSound;
	self.originalMotorSoundRun = self.motorSoundRun;
	
	self.originalPowershiftMotorSound = self.powershiftMotorSound;
	self.originalPowershiftMotorSoundRun = self.powershiftMotorSoundRun;

	self.soundSwitched = true;
	self.motorStartHandled = false;

	self.powershiftMotorSound = self.powershiftMotorSoundInternal;
	self.powershiftMotorSoundRun =self.powershiftMotorSoundInternalRun;
	self.motorSound = self.motorSoundInternal;
	self.motorSoundRun =self.motorSoundInternalRun;

	--Tre links
	local oSX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.osx#index"));
    if oSX ~= nil then
        self.osx = {};
        self.osx.node = oSX;
		end;

	--Tre rechts
	local oDX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.odx#index"));
    if oDX ~= nil then
        self.odx = {};
        self.odx.node = oDX;
		end;	

	--Heckfenster
	local oRX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.orx#index"));
    if oRX ~= nil then
        self.orx = {};
        self.orx.node = oRX;
		end;

	--Dachluke
    local tSUP = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tsup#index"));
    if  tSUP~= nil then
        self.tsup = {};
        self.tsup.node = tSUP;
		end;

	--Fenster links
	local panL = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.panl#index"));
		if  panL~= nil then
			self.panl = {};
			self.panl.node = panL;
			end;

	--Fenster rechts
	local panR = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.panr#index"));
		if  panR~= nil then
			self.panr = {};
			self.panr.node = panR;
			end;				
	
	--Frontscheibe
	local opX = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.opx#index"));
    if  opX~= nil then
        self.opx = {};
        self.opx.node = opX;
		end;

	self.dehihoho1=true;
	self.dehihoho2=true;
	self.dehihoho3=true;
	self.dehihoho4=true;
	self.dehihoho5=true;
	self.dehihoho6=true;
	self.dehihoho7=true;
	self.p=false;

end;

function internalclod:delete()
end;

function internalclod:mouseEvent(posX, posY, isDown, isUp, button)
end;

function internalclod:keyEvent(unicode, sym, modifier, isDown)

end;

function internalclod:update(dt)
	if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) and self.isEntered then
		self.soundSwitched = true;
	end;

	   local x, y, z = getRotation(self.osx.node);
			
			if y > Utils.degToRad(-1.5) and y < Utils.degToRad(-0.01)  then
			self.dehihoho1=true;
			self.soundSwitched=true;
			else
			
			if y < Utils.degToRad(-1.5) and y > Utils.degToRad(-3)  then
			self.dehihoho1=false;
			self.soundSwitched=true;
			end;
			end;
			

		local xd, yd, zd = getRotation(self.odx.node);
			
			if yd < Utils.degToRad(1.5) and yd > Utils.degToRad(0.01)  then
			self.dehihoho4=true;
			self.soundSwitched=true;
			else
			
			if yd > Utils.degToRad(1.5) and yd < Utils.degToRad(3)  then
			self.dehihoho4=false;
			self.soundSwitched=true;
			end;
			end;	
			

		 local xz, yz, zz = getRotation(self.orx.node);
			
			if xz < Utils.degToRad(1) and  xz > Utils.degToRad(0.01) then
			self.dehihoho2=true;
			self.soundSwitched=true;
			else
			
			if xz > Utils.degToRad(1) and xz < Utils.degToRad(3)  then
			self.dehihoho2=false;
			self.soundSwitched=true;
			end;
			end;
			
	
		local xpl, ypl, zpl = getRotation(self.panl.node);
			
			if ypl < Utils.degToRad(0.5) and ypl > Utils.degToRad(0.01)  then
			self.dehihoho5=true;
			self.soundSwitched=true;
			else

			if ypl > Utils.degToRad(1) and ypl < Utils.degToRad(2)  then
			self.dehihoho5=false;
			self.soundSwitched=true;
			end;
			end;
			

		local xpr, ypr, zpr = getRotation(self.panr.node);
			
			if ypr > Utils.degToRad(-0.5) and ypr < Utils.degToRad(-0.01)  then
			self.dehihoho6=true;
			self.soundSwitched=true;
			else

			if ypr < Utils.degToRad(-1) and ypr > Utils.degToRad(-2)  then
			self.dehihoho6=false;
			self.soundSwitched=true;
			end;
			end
			

		local xt, yt, zt = getRotation(self.tsup.node);
			
			if xt < Utils.degToRad(1) and  xt > Utils.degToRad(0.01) then
			self.dehihoho3=true;
			self.soundSwitched=true;
			else

			if xt > Utils.degToRad(1) and xt < Utils.degToRad(3)  then
			self.dehihoho3=false;
			self.soundSwitched=true;
			end;
			end;
			

		local xz, yz, zz = getRotation(self.opx.node);
			
			if xz < Utils.degToRad(1) and  xz > Utils.degToRad(0.01) then
			self.dehihoho7=true;
			self.soundSwitched=true;
			else

			if xz > Utils.degToRad(1) and xz < Utils.degToRad(3)  then
			self.dehihoho7=false;
			self.soundSwitched=true;
			end;
			end;	


	if self.playMotorSoundTime ~= nil and self.playMotorSoundTime <= self.time and not self.motorStartHandled then
		self.motorStartHandled = true;
		self.soundSwitched = true;
	end;

	if self.soundSwitched then
		if table.getn(self.wheels) > 0 then
			stopSample(self.motorSound);
			stopSample(self.motorSoundRun);
			stopSample(self.powershiftMotorSound);
			stopSample(self.powershiftMotorSoundRun);

			if not self.enabledPowershiftGearBox then
				if self.camIndex == self.intCameraIndex and self.dehihoho1 and self.dehihoho2 and self.dehihoho3 and self.dehihoho4 and self.dehihoho5 and self.dehihoho6 and self.dehihoho7 then

					self.motorStartSound = self.motorStartSoundInternal;
					self.motorStopSound = self.motorStopSoundInternal;
					self.motorSound = self.motorSoundInternal;
					self.motorSoundRun =self.motorSoundInternalRun;
				else								
					self.motorStartSound = self.originalMotorStartSound;
					self.motorStopSound = self.originalMotorStopSound;
					self.motorSound = self.originalMotorSound;
					self.motorSoundRun =self.originalMotorSoundRun;
				end;

				if self.isMotorStarted then
					if self:getIsActiveForSound() then
						if self.motorSound ~= nil then

							playSample(self.motorSound, 0, self.motorSoundVolume, 0);
							self.playMotorSound = false;

							if self.motorSoundRun ~= nil then
								playSample(self.motorSoundRun, 0, 0.0, 0);
							end;
						end;
					end;
				end;
			else
				if self.camIndex == self.intCameraIndex and self.dehihoho1 and self.dehihoho2 and self.dehihoho3 and self.dehihoho4 and self.dehihoho5 and self.dehihoho6 and self.dehihoho7 then

					self.motorStartSound = self.motorStartSoundInternal;
					self.motorStopSound = self.motorStopSoundInternal;
					self.powershiftMotorSound = self.powershiftMotorSoundInternal;
					self.powershiftMotorSoundRun =self.powershiftMotorSoundInternalRun;
				else
					self.motorStartSound = self.originalMotorStartSound;
					self.motorStopSound = self.originalMotorStopSound;
					self.powershiftMotorSound = self.originalPowershiftMotorSound;
					self.powershiftMotorSoundRun =self.originalPowershiftMotorSoundRun;
				end;

				if self.isMotorStarted then
					if self:getIsActiveForSound() then
						if self.powershiftMotorSound ~= nil and self.playMotorSoundTime <= self.time then
							playSample(self.powershiftMotorSound, 0, self.powershiftMotorSoundVolume, 0);
							self.playPowershiftMotorSound = false;

							if self.powershiftMotorSoundRun ~= nil then
								playSample(self.powershiftMotorSoundRun, 0, 0.0, 0);
							end;

						end;
					end;
				end;
			end;
		end;
		self.soundSwitched = false;
	end;
end;

function internalclod:onLeave()
   
	self.soundSwitched = true;
    Motorized.stopSounds(self);
end;

function internalclod:onEnter()
   
	self.soundSwitched = true;
end;

function internalclod:startMotor()
	self.motorStartHandled = false;
end;

function internalclod:draw()
end;