--
-- handThrottle
-- Specialization for hand throttle on steerables
--
-- @author  Templaer
-- @date  12/06/09
--
-- Modifikationen erst nach Rcksprache
-- Do not edit without my permission
--

handThrottle = {};

function handThrottle.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function handThrottle:load(xmlFile)
    self.handThrottleMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    self.handThrottleMaxRpm = self.motor.maxRpm[3];
	self.handThrottleEnabled = false;
    self.handThrottlePercentage = 0.05;
	
		
	
	
end;

function handThrottle:delete()
	
end;

function handThrottle:mouseEvent(posX, posY, isDown, isUp, button)
end;

function handThrottle:keyEvent(unicode, sym, modifier, isDown)
end;

function handThrottle:update(dt)
    if self.isMotorStarted then

	    local roundPerMinute = self.lastRoundPerMinute*1 + (1-1)*(self.motor.lastMotorRpm-self.motor.minRpm);
        local rpmDiff = math.abs(roundPerMinute - ((self.handThrottleMaxRpm * 1.1) * self.handThrottlePercentage));
	
        if self:getIsActiveForInput() then
		
            if InputBinding.isPressed(InputBinding.MORERPM) and self.handThrottlePercentage < 1 then
		       self.handThrottlePercentage = self.handThrottlePercentage + 0.005; 
					self.handThrottleEnabled = true;
				
			end;
		    
			if InputBinding.isPressed(InputBinding.LESSRPM) and self.handThrottlePercentage > 0.05 then 
		      self.handThrottlePercentage = self.handThrottlePercentage - 0.005; 
					self.handThrottleEnabled = true;
					
	        end;
			
		    if InputBinding.hasEvent(InputBinding.RESETRPM) then
		        self.handThrottleEnabled = false;
				self.motor.minRpm = self.handThrottleMinRpm;
				self.handThrottlePercentage = 0.05;
		    end;
        end;
	
	    if self.handThrottleEnabled then
		
            if roundPerMinute < ((self.handThrottleMaxRpm * self.handThrottlePercentage) - 100) then
                self.motor.minRpm = self.motor.minRpm - (rpmDiff / 10);
				-- Utils.setEmittingState(self.workExhaustParticleSystems, true);
            elseif roundPerMinute > ((self.handThrottleMaxRpm * self.handThrottlePercentage) + 100) then
			    if self.motor.minRpm <= (self.handThrottleMinRpm - (rpmDiff/10)) then
                    self.motor.minRpm = self.motor.minRpm + (rpmDiff / 10);
			     end;
            end;
			
		end;
	end;
end;


function handThrottle:stopMotor()
    self.motor.minRpm = self.handThrottleMinRpm;
	
end;
	
function handThrottle:onLeave()
    self.motor.minRpm = self.handThrottleMinRpm;
	
end;

function handThrottle:draw()
end;

