--
-- OperatingHours
-- Specialization for counting the operating hours of a vehicle
--
-- @author:  	Manuel Leithner
-- @date:		29/08/10
-- @version:	v2.0
-- @history:	v1.0 - initial implementation
--				v2.0 - convert to LS2011 (Networksupport) and some bugfixes

--@edit to KvernelandGF8200OperatingHours: Ifko[nator]
--@date:		04/03/13

KvernelandGF8200OperatingHours = {};

function KvernelandGF8200OperatingHours.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function KvernelandGF8200OperatingHours:load(xmlFile)

	self.addOperatingTime = SpecializationUtil.callSpecializationsFunction("addOperatingTime");
	self.operatingTime = 0;	
	self.ohX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.operatingHours#posX"), 0.6543);
	self.ohY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.operatingHours#posY"), 0.1315);
	self.yOffset = 0.0077;
	self.ohOverlay = Overlay:new("hudOHOverlay", Utils.getFilename("Scripts/KvernelandGF8200OperatingHours_hud.png", self.baseDirectory), self.ohX, self.ohY, 0.11855, 0.039525);	
end;

function KvernelandGF8200OperatingHours:delete()
end;

function KvernelandGF8200OperatingHours:readStream(streamId, connection)
	self:addOperatingTime(streamReadFloat32(streamId), true);
end;

function KvernelandGF8200OperatingHours:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self.operatingTime);
end;

function KvernelandGF8200OperatingHours:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KvernelandGF8200OperatingHours:keyEvent(unicode, sym, modifier, isDown)
end;

function KvernelandGF8200OperatingHours:update(dt)
end;

function KvernelandGF8200OperatingHours:updateTick(dt)
    if self:getIsActive() or self.isHired then 
		self:addOperatingTime(dt);
	end;
end;

function KvernelandGF8200OperatingHours:draw()
	
	local operatingHours = math.floor((self.operatingTime / 1000 / 60 / 60)*10) / 10;
	local hours = math.floor(operatingHours);
	local minutes = tostring(math.floor((operatingHours - hours)*10));
	
	self.ohOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	renderText(self.ohX+0.062, self.ohY+self.yOffset, 0.022, tostring(hours) .. ",");
	setTextColor(0.95,0,0,1);
	renderText(self.ohX+0.071, self.ohY+self.yOffset, 0.023, minutes);
	setTextColor(1,1,1,1);
	renderText(self.ohX+0.08, self.ohY+self.yOffset, 0.023, "h");
	setTextAlignment(RenderText.ALIGN_LEFT);
end;

function KvernelandGF8200OperatingHours:addOperatingTime(addTime)
	
	local time = math.max(Utils.getNoNil(addTime, 0), 0);	
	self.operatingTime = self.operatingTime + time;	
	
	if self.operatingTime > (99999.9 * 1000 * 60 * 60) then
		self.operatingTime = 0;
	end;
end;

function KvernelandGF8200OperatingHours:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local operatingTime = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#operatingTime"), self.operatingTime) * 1000;
		self:addOperatingTime(operatingTime);
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function KvernelandGF8200OperatingHours:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'operatingTime="' .. tostring((self.operatingTime / 1000)) ..'"';
	return attributes, nil;
end;