--
-- SpringhillMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SpringhillMap = {}

local SpringhillMap_mt = Class(SpringhillMap, Mission00);


function SpringhillMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SpringhillMap_mt;
    end;
    local self = SpringhillMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SpringhillMap:delete()
    SpringhillMap:superClass().delete(self);
end;

function SpringhillMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SpringhillMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("SpringhillMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    -- ATMs
    self.missionPDA:createMapHotspot("Bank", Utils.getFilename("$dataS2/missions/hud_pda_spot_bank.png", self.baseDirectory), -241, 218, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	

    -- Vehicle Shop
    self.missionPDA:createMapHotspot("Shop", Utils.getFilename("$dataS2/missions/hud_pda_spot_shop.png", self.baseDirectory), -352, 189, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- Phone Booths
    self.missionPDA:createMapHotspot("Phone", Utils.getFilename("$dataS2/missions/hud_pda_spot_phone.png", self.baseDirectory), -276.5, 218, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- farm silos
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 107, -18, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), 714, 120, iconSize, iconSize * (4 / 3), false, false, false, 0, true);	
    -- bga
    self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlace.png", self.baseDirectory), -426, 27, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    
    -- Grass Heaps
	-- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 888.8 , 569.6, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 753.5 , 1024 + 864.9, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 640.4 , 1024 + 787.2, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    -- self.missionPDA:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/missions/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), 1024 + 692.7 , 1024 - 842.7, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    -- livestock
    self.missionPDA:createMapHotspot("Cows", Utils.getFilename("$dataS2/missions/hud_pda_spot_cows.png", self.baseDirectory), 73, 49, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Sheep", Utils.getFilename("$dataS2/missions/hud_pda_spot_sheep.png", self.baseDirectory),  200, 670, iconSize, iconSize * (4 / 3), false, false, false, 0, true);
    self.missionPDA:createMapHotspot("Chickens", Utils.getFilename("$dataS2/missions/hud_pda_spot_chickens.png", self.baseDirectory), 173, 541, iconSize, iconSize * (4 / 3), false, false, false, 0, true);

    SpringhillMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SpringhillMap:onStartMission()
    SpringhillMap:superClass().onStartMission(self);
end;

function SpringhillMap:mouseEvent(posX, posY, isDown, isUp, button)
    SpringhillMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SpringhillMap:keyEvent(unicode, sym, modifier, isDown)
    SpringhillMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SpringhillMap:update(dt)
    SpringhillMap:superClass().update(self, dt);
end;

function SpringhillMap:draw()
    SpringhillMap:superClass().draw(self);
end;