--
-- SetLowerMarkerEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--

SetLowerMarkerEvent = {};
SetLowerMarkerEvent_mt = Class(SetLowerMarkerEvent, Event);

InitEventClass(SetLowerMarkerEvent, "SetLowerMarkerEvent");

function SetLowerMarkerEvent:emptyNew()
    local self = Event:new(SetLowerMarkerEvent_mt);
    self.className="SetLowerMarkerEvent";
    return self;
end;

function SetLowerMarkerEvent:new(object, markerId, isDown)
    local self = SetLowerMarkerEvent:emptyNew()
    self.object = object;
	self.markerId = markerId;
	self.isDown = isDown;
    return self;
end;

function SetLowerMarkerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.markerId = streamReadUIntN(streamId, 2);
	self.isDown = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetLowerMarkerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUIntN(streamId, self.markerId, 2);
	streamWriteBool(streamId, self.isDown);
end;

function SetLowerMarkerEvent:run(connection)
    self.object:setLowerMarker(self.markerId, self.isDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLowerMarkerEvent:new(self.object, self.markerId, self.isDown), nil, connection, self.object);
    end;
end;

function SetLowerMarkerEvent.sendEvent(vehicle, markerId, isDown, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLowerMarkerEvent:new(vehicle, markerId, isDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLowerMarkerEvent:new(vehicle, markerId, isDown));
		end;
	end;
end;

