--
-- SetLowerDiscsEvent
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		13/05/11
-- @history:	v1.0 - Initial version
--


SetLowerDiscsEvent = {};
SetLowerDiscsEvent_mt = Class(SetLowerDiscsEvent, Event);

InitEventClass(SetLowerDiscsEvent, "SetLowerDiscsEvent");

function SetLowerDiscsEvent:emptyNew()
    local self = Event:new(SetLowerDiscsEvent_mt);
    self.className="SetLowerDiscsEvent";
    return self;
end;

function SetLowerDiscsEvent:new(object, isDown)
    local self = SetLowerDiscsEvent:emptyNew()
    self.object = object;
	self.isDown = isDown;
    return self;
end;

function SetLowerDiscsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isDown = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetLowerDiscsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isDown);
end;

function SetLowerDiscsEvent:run(connection)
    self.object:setLowerDiscs(self.isDown, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetLowerDiscsEvent:new(self.object, self.isDown), nil, connection, self.object);
    end;
end;

function SetLowerDiscsEvent.sendEvent(vehicle, isDown, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetLowerDiscsEvent:new(vehicle, isDown), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetLowerDiscsEvent:new(vehicle, isDown));
		end;
	end;
end;

