SetRightTracerEvent = {};
SetRightTracerEvent_mt = Class(SetRightTracerEvent, Event);

InitEventClass(SetRightTracerEvent, "SetRightTracerEvent");

function SetRightTracerEvent:emptyNew()
    local self = Event:new(SetRightTracerEvent_mt);
    self.className="SetRightTracerEvent";
    return self;
end;

function SetRightTracerEvent:new(vehicle, isRightUnfold)
    local self = SetRightTracerEvent:emptyNew()
    self.vehicle = vehicle;
	self.isRightUnfold = isRightUnfold;
    return self;
end;

function SetRightTracerEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isRightUnfold = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetRightTracerEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isRightUnfold);
end;

function SetRightTracerEvent:run(connection)   
	self.vehicle:setRightTracer(self.isRightUnfold, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetRightTracerEvent:new(self.vehicle, self.isRightUnfold), nil, connection, self.vehicle);
    end;
end;

function SetRightTracerEvent.sendEvent(vehicle, isRightUnfold, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetRightTracerEvent:new(vehicle, isRightUnfold), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetRightTracerEvent:new(vehicle, isRightUnfold));
		end;
	end;
end;