--
-- BalerCounter
-- This is the specialization for automatic bale loaders
--
-- @author  Manuel Leithner
-- @date  17/05/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

BalerCounter = {};

function BalerCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function BalerCounter:load(xmlFile)


	self.totalBaleCount = 0;
	self.sessionBaleCount = 0;
	
	self.bcX = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.baleCounter#posX"), 0.7543);
	self.bcY = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.baleCounter#posY"), 0.1715);
	self.yOffset = 0.0085;
	
	self.bcOverlay = Overlay:new("hudBCOverlay", Utils.getFilename("BalingCounter.png", self.baseDirectory), self.bcX, self.bcY, 0.2371, 0.039525);	
end;

function BalerCounter:delete()

end;

function BalerCounter:readStream(streamId, connection)
	local session = streamReadInt32(streamId);
	local total = streamReadInt32(streamId);	
	self.sessionBaleCount = session;
	self.totalBaleCount = total;
end;

function BalerCounter:writeStream(streamId, connection)	
	streamWriteInt32(streamId, self.totalBaleCount);
	streamWriteInt32(streamId, self.sessionBaleCount);
end;

function BalerCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BalerCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function BalerCounter:update(dt)
	
end;

function BalerCounter:draw()
	setTextAlignment(RenderText.ALIGN_CENTER);	
	self.bcOverlay:render();
	setTextBold(true);	
	setTextColor(0, 0, 0, 1);
    renderText(self.bcX+0.063, self.bcY+self.yOffset - 0.003, 0.024, tostring(self.totalBaleCount));
	renderText(self.bcX+0.063 + 0.2371/2, self.bcY+self.yOffset - 0.003, 0.024, tostring(self.sessionBaleCount));
	setTextColor(1,1,1,1);
	renderText(self.bcX+0.063, self.bcY+self.yOffset, 0.024, tostring(self.totalBaleCount));
	renderText(self.bcX+0.063 + 0.2371/2, self.bcY+self.yOffset, 0.024, tostring(self.sessionBaleCount));
	setTextColor(0, 0, 0, 1);
	setTextColor(1,1,1,1);
	setTextBold(false);	
	setTextAlignment(RenderText.ALIGN_LEFT);
end

function BalerCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)	
	if not resetVehicles then
		local totalBaleCount = Utils.getNoNil(getXMLInt(xmlFile, key .. "#totalBales"), self.totalBaleCount);
		self.totalBaleCount = totalBaleCount;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;

function BalerCounter:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'totalBales="' .. tostring(self.totalBaleCount) ..'"';
	return attributes, nil;
end;

local dropOld = Baler.dropBale;
Baler.dropBale = function(self, baleIndex)
	dropOld(self, baleIndex);
	if self.totalBaleCount ~= nil then
		self.totalBaleCount = self.totalBaleCount + 1;
		self.sessionBaleCount = self.sessionBaleCount + 1;
	end;
end;
function BalerCounter:onDetach()
end;
function BalerCounter:onLeave()
end;
function BalerCounter:onDeactivate()	
end;
