--
-- twoAttacherJoints
-- Class for two attacher joints
--
-- @author  PeterJ - FS-UK modteam
-- @date  30/01/2013
--
-- Copyright (C) FS-UK modteam, Confidential, All Rights Reserved.

twoAttacherJoints = {};

function twoAttacherJoints.prerequisitesPresent(specializations)
	Vehicle.registerJointType("fastCoupling");
	return true;
end;

function twoAttacherJoints:load(xmlFile)

	self.setTriangleType = SpecializationUtil.callSpecializationsFunction("setTriangleType");
	self.getTriangleInRange = SpecializationUtil.callSpecializationsFunction("getTriangleInRange");
	self.trianglesInRange = {};
	
	self.attacherJointNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint.attacherJoint2#index"));
	if self.attacherJointNode2 ~= nil then
		self.jointTypeStr2 = getXMLString(xmlFile, "vehicle.attacherJoint.attacherJoint2#jointType")
		if self.jointTypeStr2 ~= nil then
			self.jointType2 = Vehicle.jointTypeNameToInt[self.jointTypeStr2];
			if self.jointType2 == nil then
				print("Warning: invalid jointType " .. jointTypeStr2);
			end;
			self.jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJoint#jointType")
			self.jointType = Vehicle.jointTypeNameToInt[self.jointTypeStr];
			self.attacherJointNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoint#index"));
		end;
	end;
	self.jointRangeNode = self.attacherJointNode2;
	self.isTriangleReady = false;
end;

function twoAttacherJoints:delete()
end;

function twoAttacherJoints:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	--if not resetVehicles then
		local triangleReady = getXMLBool(xmlFile, key.."#triangleJoint");
		if triangleReady ~= nil then
			self:setTriangleType(triangleReady);
			self.isTriangleReady = triangleReady;
		end;
	--end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function twoAttacherJoints:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';

	local mystring = 'triangleJoint="' .. tostring(self.isTriangleReady) ..'"';	
	attributes = attributes .. mystring;

    local node = nil;
	return attributes, node;
end;

function twoAttacherJoints:mouseEvent(posX, posY, isDown, isUp, button)
end;

function twoAttacherJoints:keyEvent(unicode, sym, modifier, isDown)
end;

function twoAttacherJoints:update(dt)
end;

function twoAttacherJoints:updateTick(dt)
	if not self:getIsActive() then
		self:getTriangleInRange();
		if table.getn(self.trianglesInRange) > 0 then
			if self.attacherJoint.jointType == self.jointType then
				self:setTriangleType(true);
			end;
		else
			if self.attacherJoint.jointType == self.jointType2 then
				self:setTriangleType(false);
			end;
		end;
	end;
end;

function twoAttacherJoints:draw()
end;

function twoAttacherJoints:setTriangleType(isTriangleReady)
	if isTriangleReady ~= self.isTriangleReady then
		self.isTriangleReady = isTriangleReady;
		if self.isTriangleReady then
			self.attacherJoint.node = self.attacherJointNode2;
			self.attacherJoint.jointType = self.jointType2;
		else
			self.attacherJoint.node = self.attacherJointNode;
			self.attacherJoint.jointType = self.jointType;
		end;
	end;
end

function twoAttacherJoints:getTriangleInRange()
	self.trianglesInRange = {}; 
	local nearestDistance = 0.95;
	local px, py, pz = getWorldTranslation(self.jointRangeNode);
	for k,v in pairs(g_currentMission.attachables) do
		if v.isTriangle then
			local vx, vy, vz = getWorldTranslation(v.rootNode);
			local distance = Utils.vector2Length(px-vx, pz-vz);
			if distance < nearestDistance then
				table.insert(self.trianglesInRange, v);
			end; 
		end;
    end;
end;
