PZMowerAreaEvent = {};
PZMowerAreaEvent_mt = Class(PZMowerAreaEvent, Event);
 
InitEventClass(PZMowerAreaEvent, "PZMowerAreaEvent");
  
function PZMowerAreaEvent:emptyNew()
      local self = Event:new(PZMowerAreaEvent_mt);
      self.className="PZMowerAreaEvent";
      return self;
end;
  
function PZMowerAreaEvent:new(cuttingAreas)
      local self = PZMowerAreaEvent:emptyNew()
      self.cuttingAreas = cuttingAreas;
      return self;
end;
  
function PZMowerAreaEvent:readStream(streamId, connection)
      local numAreas = streamReadUIntN(streamId, 4);
      local refX = streamReadFloat32(streamId);
      local refY = streamReadFloat32(streamId);
      local values = Utils.readCompressed2DVectors(streamId, refX, refY, numAreas*3-1, 0.01, true);
      for i=1,numAreas do
          local vi = i-1;
          local x = values[vi*3+1].x;
          local z = values[vi*3+1].y;
          local x1 = values[vi*3+2].x;
          local z1 = values[vi*3+2].y;
          local x2 = values[vi*3+3].x;
          local z2 = values[vi*3+3].y;
          Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
      end;
end;
  
function PZMowerAreaEvent:writeStream(streamId, connection)
     local numAreas = table.getn(self.cuttingAreas);
      streamWriteUIntN(streamId, numAreas, 4);
      local refX, refY;
      local values = {};
      for i=1, numAreas do
          local d = self.cuttingAreas[i];
          if i==1 then
              refX = d[1];
              refY = d[2];
              streamWriteFloat32(streamId, d[1]);
              streamWriteFloat32(streamId, d[2]);
          else
              table.insert(values, {x=d[1], y=d[2]});
          end;
          table.insert(values, {x=d[3], y=d[4]});
          table.insert(values, {x=d[5], y=d[6]});
      end;
     assert(table.getn(values) == numAreas*3 - 1);
      Utils.writeCompressed2DVectors(streamId, refX, refY, values, 0.01);
end;
  
function PZMowerAreaEvent:run(connection)
      print("Error: Do not run PZMowerAreaEvent locally");
end;
  
function PZMowerAreaEvent.runLocally(cuttingAreas)
       local totalArea =0;     
      local numAreas = table.getn(cuttingAreas);
  
      local refX, refY;
      local values = {};
      for i=1, numAreas do
          local d = cuttingAreas[i];
          if i==1 then
              refX = d[1];
              refY = d[2];
          else
              table.insert(values, {x=d[1], y=d[2]});
          end;
          table.insert(values, {x=d[3], y=d[4]});
          table.insert(values, {x=d[5], y=d[6]});
      end;
       assert(table.getn(values) == numAreas*3 - 1);
  
      local values = Utils.simWriteCompressed2DVectors(refX, refY, values, 0.01, true);
  
      for i=1, numAreas do
          local vi = i-1;
          local x = values[vi*3+1].x;
          local z = values[vi*3+1].y;
          local x1 = values[vi*3+2].x;
          local z1 = values[vi*3+2].y;
          local x2 = values[vi*3+3].x;
          local z2 = values[vi*3+3].y;
          local area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
		  
            
              area = area + Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
              if area > 0 then
  
                  totalArea = totalArea+area;
              end;
  

      return totalArea;		  
      end;
end;

PZFoldDirectionEvent = {};
PZFoldDirectionEvent_mt = Class(PZFoldDirectionEvent, Event);
  
InitEventClass(PZFoldDirectionEvent, "PZFoldDirectionEvent");
  
function PZFoldDirectionEvent:emptyNew()
	local self = Event:new(PZFoldDirectionEvent_mt);
	self.className="PZFoldDirectionEvent";
	return self;
end;
    
function PZFoldDirectionEvent:new(object, direction)
	local self = PZFoldDirectionEvent:emptyNew(direction)
	self.object = object;
	self.direction = Utils.sign(direction);
	return self;
end;
  
function PZFoldDirectionEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.direction = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;
  
function PZFoldDirectionEvent:writeStream(streamId, connection)
		streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.direction);
end;
  
function PZFoldDirectionEvent:run(connection)
		if self.object ~= nil then
			self.object:setFoldDirection(self.direction, true);
		end;	
		if not connection:getIsServer() then
			g_server:broadcastEvent(PZFoldDirectionEvent:new(self.object, self.direction), nil, connection, self.object);
		end;

end;