--
-- silageTools
-- This is the specialization for the pack of silage tools 
--
-- @author  PeterJ - euroDZN
-- @date  12/08/2013
--
-- http://eurodzn.wordpress.com/
--
-- Copyright (C) euroDZN, Confidential, All Rights Reserved.


silageTools = {};

function silageTools.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function silageTools:load(xmlFile)

	--- un/fold tines ---
	self.setFoldTines = SpecializationUtil.callSpecializationsFunction("setFoldTines");
	self.tinesAnimation = getXMLString(xmlFile, "vehicle.tinesAnimation#animationName");
	self.tinesFolded = false;
	self.tinesAnimDuration = self:getAnimationDuration(self.tinesAnimation);
	self.tinesStartAnimTime = 0;
	self.foldFillCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tinesAnimation#foldFillCapacity"), self.capacity);
	self.unfoldFillCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.tinesAnimation#unfoldFillCapacity"), self.capacity);

	---- hydraulic hose ----
	self.hose = {};		
	self.hose.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#index"));
	self.hose.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#scalePart"));
	self.hose.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#fixPoint"));
	self.hose.detached = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulicHose#detached"));
	if self.hose.node ~= nil and self.hose.part ~= nil then
		local ax, ay, az = getWorldTranslation(self.hose.part);
		local bx, by, bz = getWorldTranslation(self.hose.fixPoint);		
		self.hose.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		setVisibility(self.hose.node, false);
		setVisibility(self.hose.detached, true);
	end;
	self.attacherVehicleHose = nil;
	self.doJointSearch = false;
	
	--- operate grapple automatically ---
	self.autoClose = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.foldingParts#autoClose"), false);
	if self.autoClose then
		self.autoOperate = true;
		self.closeLevel = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.foldingParts#closeLevel"), 100);

		self.fillTypeGrapple = {};
		local fillTypeGrapple = getXMLString(xmlFile, "vehicle.foldingParts#fillTypeGrapple");
		if fillTypeGrapple ~= nil then
			local types = Utils.splitString(" ", fillTypeGrapple);
			for k,v in pairs(types) do
				local fillType = Fillable.fillTypeNameToInt[v];
				if fillType ~= nil then
					self.fillTypeGrapple[fillType] = true;
				else
					print("Warning: '"..self.configFileName.. "' has invalid fillTypeGrapple '"..v.."'.");
				end;
			end;
		else
			print("Warning: '"..self.configFileName.. "' fillTypeGrapple is nil '"..v.."'.");
		end;
	end;
end;
	
function silageTools:delete()
end;

function silageTools:readStream(streamId, connection)
	self:setFoldTines(streamReadBool(streamId), true);	
end;

function silageTools:writeStream(streamId, connection)
	streamWriteBool(streamId, self.tinesFolded);	
end;

function silageTools:mouseEvent(posX, posY, isDown, isUp, button)
end;

function silageTools:keyEvent(unicode, sym, modifier, isDown)
end;
  
function silageTools:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local animTime = getXMLFloat(xmlFile, key.."#tinesAnimTime");
	if animTime == nil then
		animTime = self.tinesStartAnimTime;
	else
		if animTime < 0.5 then
			self.tinesFolded = false;
			self.capacity = self.unfoldFillCapacity;
		else
			self.tinesFolded = true;
			self.capacity = self.foldFillCapacity;
		end;
		self:setFillLevel(self.fillLevel, self.currentFillType);
	end;
	silageTools.setAnimTime(self, animTime)
	return BaseMission.VEHICLE_LOAD_OK;
end;
  
function silageTools:getSaveAttributesAndNodes(nodeIdent)
	if self.tinesAnimation ~= nil then
		local animTime = self:getAnimationTime(self.tinesAnimation);
		local attributes = 'tinesAnimTime="'..animTime..'"';
		return attributes, nil;
	end;
end;

function silageTools:update(dt)
  
	if self.isClient and self:getIsActiveForInput() then
		if self.fillLevel <= self.capacity*self.fillTypeChangeThreshold and self.tinesAnimation ~= nil then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setFoldTines(not self.tinesFolded);
			end;
		end;
	end;
	if self.doJointSearch and self.hose.node ~= nil then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				local joint = self.attacherVehicle.attacherJoints[index];
				if joint.hydrahoseAttacher ~= nil then
					self.attacherVehicleHose = joint.hydrahoseAttacher;
					setVisibility(self.hose.node, true);
				else
					setVisibility(self.hose.node, false);
				end;
			end;
		end;
		self.doJointSearch = false;
	end;
	if self:getIsActive() then
		if self.attacherVehicleHose ~= nil and self.hose.node ~= nil then		
			local ax, ay, az = getWorldTranslation(self.hose.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehicleHose);
			local x, y, z = worldDirectionToLocal(getParent(self.hose.node), bx-ax, by-ay, bz-az);
			setDirection(self.hose.node, x, y, z, 0, 1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setScale(self.hose.part, 1, 1, distance/self.hose.distance);
		end;
	end;
end;

function silageTools:updateTick(dt)

	if self:getIsActive() then
		if self.autoClose then
			if (self.fillLevel/self.capacity)*100 >= self.closeLevel then
				if self.autoOperate then
					if self.fillTypeGrapple[self.currentFillType] then
						self:setFoldState(-self.turnOnFoldDirection, false);
						self.autoOperate = false;
					end;
				end;
			else
				self.autoOperate = true;
			end;
		end;	
	end;
end;

function silageTools:draw()
	if self:getIsActive() then
		if self.fillLevel <= self.capacity*self.fillTypeChangeThreshold and self.tinesAnimation ~= nil then
			if self.tinesFolded then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("unfold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("fold_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
end;

function silageTools:onAttach(attacherVehicle)
	self.doJointSearch = true;
	if self.hose.detached ~= nil then
		setVisibility(self.hose.detached, false);
	end;
end;

function silageTools:onDetach()
	self.attacherVehicleHose = nil;
	if self.hose.node ~= nil and self.hose.detached ~= nil then
		setVisibility(self.hose.node, false);
		setVisibility(self.hose.detached, true);
	end;
end;

function silageTools:setFoldTines(tinesFolded,noEventSend)
	setFoldTinesEvent.sendEvent(self, tinesFolded, noEventSend);
	self.tinesFolded = tinesFolded;
	if self.tinesFolded then
		if self.tinesAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.tinesAnimation, 1, nil, true);
			self.capacity = self.foldFillCapacity;
		end;
	else
		if self.tinesAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.tinesAnimation, -1, nil, true);
			self.capacity = self.unfoldFillCapacity;
		end;
	end;	
end;

function silageTools.setAnimTime(self, animTime)
	if self.tinesAnimation ~= nil then
		self.tinesAnimTime = animTime;
		local stopAnimTime = (self.tinesAnimTime*self.tinesAnimDuration)/self:getAnimationDuration(self.tinesAnimation);
		self:playAnimation(self.tinesAnimation, 1, nil, true);
		self:setAnimationStopTime(self.tinesAnimation, stopAnimTime);
		AnimatedVehicle.updateAnimationByName(self, self.tinesAnimation, 99999999);
	end;
end;

setFoldTinesEvent = {};
setFoldTinesEvent_mt = Class(setFoldTinesEvent, Event);

InitEventClass(setFoldTinesEvent, "setFoldTinesEvent");

function setFoldTinesEvent:emptyNew()
    local self = Event:new(setFoldTinesEvent_mt);
    self.className="setFoldTinesEvent";
    return self;
end;

function setFoldTinesEvent:new(vehicle, tinesFolded)
    local self = setFoldTinesEvent:emptyNew()
    self.vehicle = vehicle;
	self.tinesFolded = tinesFolded;
    return self;
end;

function setFoldTinesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.tinesFolded = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function setFoldTinesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.tinesFolded);
end;

function setFoldTinesEvent:run(connection)   
	self.vehicle:setFoldTines(self.tinesFolded, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setFoldTinesEvent:new(self.vehicle, self.tinesFolded), nil, connection, self.vehicle);
    end;
end;

function setFoldTinesEvent.sendEvent(vehicle, tinesFolded, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setFoldTinesEvent:new(vehicle, tinesFolded), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(setFoldTinesEvent:new(vehicle, tinesFolded));
		end;
	end;
end;
